/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.TextPainter;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleProxy;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class BlendedBackgroundPainter
extends TextPainter {
    private final RGB gridBackgroundColour;

    public BlendedBackgroundPainter(RGB gridBackgroundColour) {
        this.gridBackgroundColour = gridBackgroundColour;
    }

    @Override
    protected Color getBackgroundColour(ILayerCell cell, IConfigRegistry configRegistry) {
        return BlendedBackgroundPainter.blendBackgroundColour(cell, configRegistry, this.gridBackgroundColour);
    }

    public static Color blendBackgroundColour(ILayerCell cell, IConfigRegistry configRegistry, RGB baseColor) {
        List<Color> colours = CellStyleUtil.getAllBackgroundColors(cell, configRegistry, DisplayMode.NORMAL);
        if (cell.getDisplayMode().equals((Object)DisplayMode.SELECT)) {
            CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, DisplayMode.SELECT, cell.getConfigLabels().getLabels());
            colours.add(cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        }
        if (colours.size() == 0) {
            return null;
        }
        if (colours.size() == 1) {
            return colours.get(0);
        }
        RGB rgb = colours.get(0).getRGB();
        int i = 1;
        while (i < colours.size()) {
            if (rgb.equals((Object)baseColor)) {
                rgb = colours.get(i).getRGB();
            } else if (!colours.get(i).getRGB().equals((Object)baseColor)) {
                rgb = GUIHelper.blend(rgb, colours.get(i).getRGB());
            }
            ++i;
        }
        return GUIHelper.getColor(rgb);
    }
}

