/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico;

import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.internal.r.rdata.DirectReferenceVar;
import org.eclipse.statet.internal.r.rdata.RFunction2;
import org.eclipse.statet.internal.r.rdata.RLanguageVar;
import org.eclipse.statet.internal.r.rdata.RMissingVar;
import org.eclipse.statet.internal.r.rdata.RNullVar;
import org.eclipse.statet.internal.r.rdata.ROtherVar;
import org.eclipse.statet.internal.r.rdata.RPromiseVar;
import org.eclipse.statet.internal.r.rdata.RReferenceVar;
import org.eclipse.statet.internal.r.rdata.RVectorVar;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRReference;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RFunction;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.RVector;

@NonNullByDefault
public interface ICombinedRDataAdapter
extends IRDataAdapter {
    public static CombinedRReference createReference(long handle, RElementName name, byte type, String className) {
        return new RReferenceVar(handle, type, className, null, name);
    }

    public static CombinedRReference createReference(CombinedRElement element, RElementName name) {
        return new DirectReferenceVar(element, null, name);
    }

    public static CombinedRElement create(RObject rObject, RElementName name) {
        BasicCombinedRElement parent = null;
        switch (rObject.getRObjectType()) {
            case 1: {
                return new RNullVar(parent, name);
            }
            case 2: {
                return new RVectorVar((RVector)rObject, parent, name);
            }
            case 12: {
                return new RLanguageVar((RLanguage)rObject, parent, name);
            }
            case 13: {
                return new RFunction2((RFunction)rObject, parent, name);
            }
            case 14: {
                return new RReferenceVar((RReference)rObject, parent, name);
            }
            case 15: {
                return new ROtherVar(rObject.getRClassName(), parent, name);
            }
            case 17: {
                return new RMissingVar(parent, name);
            }
            case 18: {
                return new RPromiseVar(parent, name);
            }
        }
        throw new UnsupportedOperationException();
    }

    public CombinedRElement evalCombinedStruct(String var1, int var2, int var3, @Nullable RElementName var4, ProgressMonitor var5) throws StatusException;

    public CombinedRElement evalCombinedStruct(String var1, @Nullable RObject var2, int var3, int var4, @Nullable RElementName var5, ProgressMonitor var6) throws StatusException;

    public CombinedRElement evalCombinedStruct(RElementName var1, int var2, int var3, ProgressMonitor var4) throws StatusException;

    public CombinedRElement evalCombinedStruct(RReference var1, int var2, int var3, @Nullable RElementName var4, ProgressMonitor var5) throws StatusException;

    public @Nullable CombinedRElement findCombinedStruct(RElementName var1, @Nullable RObject var2, boolean var3, int var4, int var5, ProgressMonitor var6) throws StatusException;

    public @Nullable CombinedRElement findCombinedStruct(RElementName var1, @Nullable RElementName var2, boolean var3, int var4, int var5, ProgressMonitor var6) throws StatusException;
}

