/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.core.sourcemodel.EmbeddedInlineElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelManagerImpl;
import org.eclipse.statet.internal.r.core.sourcemodel.SourceAnalyzer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.string.InternStringCache;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.core.SourceModelStamp;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.BasicSourceModelStamp;
import org.eclipse.statet.r.core.model.RChunkElement;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.build.RProblemReporter;
import org.eclipse.statet.r.core.model.build.RSourceUnitModelContainer;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RParser;
import org.eclipse.statet.r.core.rsource.ast.RoxygenParser;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;

public class RReconciler {
    private static final boolean LOG_TIME = false;
    private final RModelManagerImpl rManager;
    protected boolean stop = false;
    private final Object raLock = new Object();
    private final StringFactory raAstStringCache;
    private final StringParserInput raInput = new StringParserInput(4096);
    private final RoxygenParser raRoxygenParser;
    private final Object rmLock = new Object();
    private final SourceAnalyzer rmScopeAnalyzer;
    private final Object rpLock = new Object();
    private final RProblemReporter rpReporter;

    public RReconciler(RModelManagerImpl manager) {
        this.rManager = manager;
        this.raAstStringCache = new InternStringCache(32);
        this.raRoxygenParser = new RoxygenParser(this.raAstStringCache);
        this.rmScopeAnalyzer = new SourceAnalyzer();
        this.rpReporter = new RProblemReporter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(RSourceUnitModelContainer adapter, int flags, IProgressMonitor monitor) {
        int type;
        RSourceUnit su = (RSourceUnit)adapter.getSourceUnit();
        int n = type = su.getModelTypeId().equals("R") ? su.getElementType() : 0;
        if (type == 0) {
            return;
        }
        Data data = new Data(adapter, monitor);
        if (data.content == null) {
            return;
        }
        Object object = this.raLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            this.updateAst(data, monitor);
        }
        if (this.stop || monitor.isCanceled() || (flags & 0xF) < 2) {
            return;
        }
        object = this.rmLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            boolean updated = this.updateModel(data);
            if (this.stop) {
                return;
            }
            if (updated) {
                this.rManager.getEventJob().addUpdate((LtkModelElement)su, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            ProblemRequestor problemRequestor = null;
            Object object2 = this.rpLock;
            synchronized (object2) {
                if (!this.stop && !monitor.isCanceled() && data.newModel == adapter.getCurrentModel() && (problemRequestor = adapter.createProblemRequestor()) != null) {
                    this.rpReporter.run(su, data.content, (RAstNode)data.ast.getRoot(), problemRequestor);
                }
            }
            if (problemRequestor != null) {
                problemRequestor.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSourceUnitModelInfo reconcile(RSourceUnit su, SourceUnitModelInfo modelInfo, List<? extends RChunkElement> chunkElements, List<? extends SourceComponent> inlineNodes, int level, IProgressMonitor monitor) {
        Object object = this.rmLock;
        synchronized (object) {
            return this.updateModel(su, modelInfo, chunkElements, inlineNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, IProgressMonitor monitor) {
        BasicSourceModelStamp stamp = new BasicSourceModelStamp(data.content.getStamp());
        data.ast = data.adapter.getCurrentAst();
        if (data.ast != null && !stamp.equals((Object)data.ast.getStamp())) {
            data.ast = null;
        }
        if (data.ast == null) {
            long startAst = System.nanoTime();
            Object input = data.content.getStartOffset() != 0 ? new OffsetStringParserInput(data.content.getText(), data.content.getStartOffset()) : this.raInput.reset(data.content.getText());
            RParser rParser = new RParser(4, this.raAstStringCache);
            rParser.setCommentLevel(100);
            SourceComponent sourceComponent = rParser.scanSourceRange(input.init(data.content.getStartOffset(), data.content.getEndOffset()), null);
            data.ast = new AstInfo(rParser.getAstLevel(), (SourceModelStamp)stamp, (AstNode)sourceComponent);
            long stopAst = System.nanoTime();
            this.raRoxygenParser.init(input.init(data.content.getStartOffset(), data.content.getEndOffset()));
            this.raRoxygenParser.update(sourceComponent);
            RSourceUnitModelContainer rSourceUnitModelContainer = data.adapter;
            synchronized (rSourceUnitModelContainer) {
                data.adapter.setAst(data.ast);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data) {
        data.newModel = (RSourceUnitModelInfo)data.adapter.getCurrentModel();
        if (data.newModel != null && !data.ast.getStamp().equals(data.newModel.getStamp())) {
            data.newModel = null;
        }
        if (data.newModel == null) {
            long startModel = System.nanoTime();
            RSourceUnitModelInfo model = this.rmScopeAnalyzer.createModel((RSourceUnit)data.adapter.getSourceUnit(), data.ast);
            boolean isOK = model != null;
            long stopModel = System.nanoTime();
            if (isOK) {
                RSourceUnitModelContainer rSourceUnitModelContainer = data.adapter;
                synchronized (rSourceUnitModelContainer) {
                    data.oldModel = (RSourceUnitModelInfo)data.adapter.getCurrentModel();
                    data.adapter.setModel(model);
                }
                data.newModel = model;
                return true;
            }
        }
        return false;
    }

    private RSourceUnitModelInfo updateModel(RSourceUnit su, SourceUnitModelInfo modelInfo, List<? extends RChunkElement> chunkElements, List<? extends SourceComponent> inlineNodes) {
        RSourceUnitModelInfo model;
        try {
            AstInfo ast = modelInfo.getAst();
            this.rmScopeAnalyzer.beginChunkSession(su, ast);
            for (RChunkElement rChunkElement : chunkElements) {
                Object rootNodes;
                SourceComponent source = rChunkElement.getAdapter(SourceComponent.class);
                if (source instanceof SourceComponent) {
                    rootNodes = ImCollections.newList((Object)((Object)source));
                } else {
                    if (!(source instanceof List)) continue;
                    rootNodes = (List)((Object)source);
                }
                this.rmScopeAnalyzer.processChunk(rChunkElement, (List<SourceComponent>)rootNodes);
            }
            for (SourceComponent sourceComponent : inlineNodes) {
                EmbeddedInlineElement inlineElement = new EmbeddedInlineElement(modelInfo.getSourceElement(), sourceComponent);
                this.rmScopeAnalyzer.processInlineNode(inlineElement, sourceComponent);
            }
        }
        finally {
            model = this.rmScopeAnalyzer.stopChunkSession();
        }
        return model;
    }

    void stop() {
        this.stop = true;
    }

    protected static class Data {
        public final RSourceUnitModelContainer adapter;
        public final SourceContent content;
        public AstInfo ast;
        public RSourceUnitModelInfo oldModel;
        public RSourceUnitModelInfo newModel;

        public Data(RSourceUnitModelContainer adapter, IProgressMonitor monitor) {
            this.adapter = adapter;
            this.content = adapter.getParseContent(monitor);
        }
    }
}

