/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.SpecItem;

@NonNullByDefault
public abstract class SubIndexed
extends RAstNode {
    final Expression expr = new Expression();
    final Args sublist = new Args(this);
    int openOffset = Integer.MIN_VALUE;
    int closeOffset = Integer.MIN_VALUE;
    int close2Offset = Integer.MIN_VALUE;

    protected SubIndexed() {
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.expr.node;
            }
            case 1: {
                return this.sublist;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        return new RAstNode[]{this.expr.node, this.sublist};
    }

    public final RAstNode getRefChild() {
        return this.expr.node;
    }

    public final Args getArgsChild() {
        return this.sublist;
    }

    public final int getSublistOpenOffset() {
        return this.openOffset;
    }

    public final int getSublistCloseOffset() {
        return this.closeOffset;
    }

    public final int getSublistClose2Offset() {
        return this.closeOffset;
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.expr.node == child) {
            return 0;
        }
        if (this.sublist == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.expr.node.acceptInR(visitor);
        this.sublist.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.expr.node);
        visitor.visit((AstNode)this.sublist);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.expr.node == child) {
            return this.expr;
        }
        return null;
    }

    @Override
    final Expression getLeftExpr() {
        return this.expr;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        if (this.getNodeType() == element.getNodeType()) {
            SubIndexed other = (SubIndexed)element;
            return this.expr.node == other.expr.node || this.expr.node != null && this.expr.node.equalsSingle(other.expr.node);
        }
        return false;
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (this.expr == expr) {
            return 70416;
        }
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        this.startOffset = this.expr.node.startOffset;
        this.endOffset = this.close2Offset != Integer.MIN_VALUE ? this.close2Offset + 1 : (this.closeOffset != Integer.MIN_VALUE ? this.closeOffset + 1 : this.sublist.endOffset);
    }

    public static final class Arg
    extends SpecItem {
        Arg(Args parent) {
            this.rParent = parent;
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_INDEXED_ARG;
        }

        @Override
        public @Nullable Args getRParent() {
            return (Args)this.rParent;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.SUB_INDEXED_ARG == element.getNodeType();
        }
    }

    public static final class Args
    extends RAstNode {
        final List<Arg> specs;

        Args(SubIndexed parent) {
            this.rParent = parent;
            this.specs = new ArrayList<Arg>();
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_INDEXED_ARGS;
        }

        @Override
        public final @Nullable RTerminal getOperator(int index) {
            return null;
        }

        @Override
        public final boolean hasChildren() {
            return !this.specs.isEmpty();
        }

        @Override
        public final int getChildCount() {
            return this.specs.size();
        }

        @Override
        public final RAstNode getChild(int index) {
            return this.specs.get(index);
        }

        @Override
        public final RAstNode[] getChildren() {
            return this.specs.toArray(new RAstNode[this.specs.size()]);
        }

        @Override
        public final int getChildIndex(AstNode child) {
            int i = this.specs.size() - 1;
            while (i >= 0) {
                if (this.specs.get(i) == child) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
            this.acceptChildren(visitor, this.specs);
        }

        public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            for (RAstNode rAstNode : this.specs) {
                visitor.visit((AstNode)rAstNode);
            }
        }

        @Override
        final @Nullable Expression getExpr(RAstNode child) {
            return null;
        }

        @Override
        final @Nullable Expression getLeftExpr() {
            return null;
        }

        @Override
        final @Nullable Expression getRightExpr() {
            return null;
        }

        @Override
        final boolean equalsSingle(RAstNode element) {
            return NodeType.SUB_INDEXED_ARGS == element.getNodeType();
        }

        @Override
        final int getMissingExprStatus(Expression expr) {
            throw new IllegalArgumentException();
        }
    }

    static final class D
    extends SubIndexed {
        D() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_INDEXED_D;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.SUB_INDEXED_D_OPEN;
        }
    }

    static final class S
    extends SubIndexed {
        S() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_INDEXED_S;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.SUB_INDEXED_S_OPEN;
        }
    }
}

