/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.internal.r.ui.rhelp.Messages;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpPreferences;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpSearchResult;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpSearchUIMatch;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RHelpSearchRequestor;

public class RHelpSearchUIQuery
implements ISearchQuery {
    private final RHelpSearchQuery query;
    private RHelpSearchResult result;

    public RHelpSearchUIQuery(RHelpSearchQuery coreQuery) {
        if (coreQuery == null) {
            throw new NullPointerException();
        }
        this.query = coreQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        RHelpSearchUIQuery rHelpSearchUIQuery = this;
        synchronized (rHelpSearchUIQuery) {
            if (this.result == null) {
                this.result = new RHelpSearchResult(this);
            }
            this.result.init(this.query.getREnv());
        }
        RHelpSearchRequestor requestor = new RHelpSearchRequestor(){

            public int getMaxFragments() {
                return (Integer)PreferenceUtils.getInstancePrefs().getPreferenceValue(RHelpPreferences.SEARCH_PREVIEW_FRAGMENTS_MAX_PREF);
            }

            public void matchFound(RHelpSearchMatch match) {
                RHelpSearchUIQuery.this.result.addMatch(new RHelpSearchUIMatch(match));
            }
        };
        try {
            RCore.getRHelpManager().search(this.query, requestor, EStatusUtils.convert((IProgressMonitor)monitor, (int)1));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (StatusException e) {
            if (e.getStatus().getSeverity() == 8) {
                IStatus iStatus = EStatusUtils.convert((org.eclipse.statet.jcommons.status.Status)e.getStatus());
                return iStatus;
            }
            Status status = new Status(4, "org.eclipse.statet.r.ui", String.format("An error occurred when performing R help search: %1$s", this.getSearchLabel()), (Throwable)EStatusUtils.convert((StatusException)e));
            return status;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String getLabel() {
        return Messages.Search_Query_label;
    }

    public String getSearchLabel() {
        String searchString = this.query.getSearchString();
        if (searchString.length() > 0) {
            switch (this.query.getSearchType()) {
                case 1: {
                    return NLS.bind((String)Messages.Search_PatternInTopics_label, (Object)searchString);
                }
                case 2: {
                    return NLS.bind((String)Messages.Search_PatternInFields_label, (Object)searchString);
                }
            }
        }
        return NLS.bind((String)Messages.Search_Pattern_label, (Object)searchString);
    }

    public boolean canRerun() {
        return this.query.getREnv().get(REnvHelpConfiguration.class) != null;
    }

    public boolean canRunInBackground() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISearchResult getSearchResult() {
        RHelpSearchUIQuery rHelpSearchUIQuery = this;
        synchronized (rHelpSearchUIQuery) {
            if (this.result == null) {
                this.result = new RHelpSearchResult(this);
                this.result.init(this.query.getREnv());
            }
            return this.result;
        }
    }

    public RHelpSearchQuery getRHelpQuery() {
        return this.query;
    }
}

