/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rhelp;

import java.net.URI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpView;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.util.AbstractREnvHandler;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class OpenRHelpHandler
extends AbstractREnvHandler {
    private final boolean reusePage;

    public OpenRHelpHandler(boolean reusePage) {
        this.reusePage = reusePage;
    }

    public OpenRHelpHandler() {
        this(true);
    }

    private @Nullable URI getUrl(REnv rEnv, @Nullable String urlString) {
        if (urlString == null || urlString.isEmpty() || urlString.equals("about:blank")) {
            return RCore.getRHelpHttpService().getREnvHttpUrl(rEnv, "browse");
        }
        return RCore.getRHelpHttpService().toHttpUrl(urlString, rEnv, "browse");
    }

    @Override
    protected @Nullable Object execute(REnv rEnv, ExecutionEvent event) throws ExecutionException {
        URI url = this.getUrl(rEnv, event.getParameter("url"));
        if (url == null) {
            return null;
        }
        try {
            RHelpView view = (RHelpView)HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage().showView("org.eclipse.statet.r.views.RHelp");
            return this.show(view, url);
        }
        catch (CoreException e) {
            throw new ExecutionException("An error occured when opening R help page in R help view.", (Throwable)e);
        }
    }

    public @Nullable IStatus execute(RTool rTool, @Nullable String urlString) {
        REnv rEnv = rTool.getREnv();
        if (rEnv == null) {
            return null;
        }
        URI url = this.getUrl(rEnv, urlString);
        if (url == null) {
            return null;
        }
        return (IStatus)UIAccess.syncExecGet(() -> {
            try {
                RHelpView view = rTool instanceof ToolProcess ? (RHelpView)NicoUITools.getView((String)"org.eclipse.statet.r.views.RHelp", (Tool)rTool, (boolean)true) : (RHelpView)UIAccess.getActiveWorkbenchPage((boolean)true).showView("org.eclipse.statet.r.views.RHelp");
                this.show(view, url);
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.statet.r.ui", "An error occured when opening R help page in R help view.", (Throwable)e);
                StatusManager.getManager().handle((IStatus)status);
                return status;
            }
        });
    }

    private BrowserSession show(RHelpView view, URI url) {
        return view.openUrl(url, this.reusePage ? BrowserSession.findSessionByUrl((ImCollection)view.getSessions(), (URI)url) : null);
    }
}

