/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.r.ui.debug;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.redocs.r.Messages;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.statet.redocs.r.core.source.DocContentSectionsRweaveExtension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class SubmitRChunkDirectLaunchShortcut
implements ILaunchShortcut {
    private final boolean gotoConsole;

    public SubmitRChunkDirectLaunchShortcut() {
        this(false);
    }

    protected SubmitRChunkDirectLaunchShortcut(boolean gotoConsole) {
        this.gotoConsole = gotoConsole;
    }

    public void launch(ISelection selection, String mode) {
    }

    public void launch(IEditorPart editor, String mode) {
        assert (mode.equals("run"));
        final Data data = new Data();
        try {
            final ISourceEditor sourceEditor = (ISourceEditor)editor.getAdapter(ISourceEditor.class);
            if (sourceEditor != null) {
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SourceViewer viewer = sourceEditor.getViewer();
                        if (UIAccess.isOkToUse((Viewer)viewer)) {
                            data.document = (AbstractDocument)viewer.getDocument();
                            DocContentSections docContentInfo = sourceEditor.getDocumentContentInfo();
                            if (docContentInfo instanceof DocContentSectionsRweaveExtension) {
                                data.docContentSections = (DocContentSectionsRweaveExtension)docContentInfo;
                            }
                            data.selection = (ITextSelection)viewer.getSelection();
                        }
                    }
                });
            }
            if (data.isComplete()) {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            SubmitRChunkDirectLaunchShortcut.this.doLaunch(data, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, Messages.RChunkLaunch_error_message, e.getTargetException()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doLaunch(Data data, IProgressMonitor monitor) throws CoreException {
        try {
            List<TreePartitionNode> rCodeRegions = data.docContentSections.getRChunkCodeRegions((IDocument)data.document, data.selection.getOffset(), data.selection.getLength());
            ArrayList lines = new ArrayList();
            for (TextRegion textRegion : rCodeRegions) {
                TextUtil.addLines((IDocument)data.document, (int)textRegion.getStartOffset(), (int)textRegion.getLength(), lines);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (lines.size() == 0 || monitor.isCanceled()) {
                return;
            }
            RCodeLaunching.runRCodeDirect(lines, (boolean)this.gotoConsole, (IProgressMonitor)monitor);
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.r", -1, "An error occurred when picking code lines.", (Throwable)e));
        }
    }

    public static class AndGotoConsole
    extends SubmitRChunkDirectLaunchShortcut {
        public AndGotoConsole() {
            super(true);
        }
    }

    private static class Data {
        private AbstractDocument document;
        private DocContentSectionsRweaveExtension docContentSections;
        private ITextSelection selection;

        private Data() {
        }

        public boolean isComplete() {
            return this.document != null && this.docContentSections != null && this.selection != null;
        }
    }
}

