/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srv.engine;

import java.rmi.RemoteException;
import java.util.Map;
import org.eclipse.statet.rj.server.REngine;
import org.eclipse.statet.rj.server.RjsComObject;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.srv.engine.SrvEngine;
import org.eclipse.statet.rj.server.srvext.Client;

public final class REngineImpl
implements REngine {
    private final Server publicServer;
    private final SrvEngine srvEngine;
    private final Client client;

    public REngineImpl(Server publicServer, SrvEngine srvEngine, Client client) {
        this.publicServer = publicServer;
        this.srvEngine = srvEngine;
        this.client = client;
    }

    @Override
    public Server getPublic() throws RemoteException {
        return this.publicServer;
    }

    @Override
    public Map<String, Object> getPlatformData() {
        return this.srvEngine.getPlatformData();
    }

    @Override
    public void setProperties(Map<String, ? extends Object> properties) throws RemoteException {
        this.srvEngine.setProperties(this.client, properties);
    }

    @Override
    public void disconnect() throws RemoteException {
        this.srvEngine.disconnect(this.client);
    }

    @Override
    public RjsComObject runAsync(RjsComObject com) throws RemoteException {
        return this.srvEngine.runAsync(this.client, com);
    }

    @Override
    public RjsComObject runMainLoop(RjsComObject com) throws RemoteException {
        return this.srvEngine.runMainLoop(this.client, com);
    }

    @Override
    public boolean isClosed() throws RemoteException {
        return this.srvEngine.getCurrentClient() != this.client;
    }
}

