/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.swt;

import org.eclipse.statet.ecommons.waltable.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.style.HorizontalAlignment;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class SWTUtil {
    public static final int getMouseWheelEventType(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? 38 : 37;
    }

    public static final ScrollBar getScrollBar(Scrollable control, Orientation orientation) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? control.getHorizontalBar() : control.getVerticalBar();
    }

    public static final LRange getRange(LRectangle lRectangle, Orientation orientation) {
        if (lRectangle == null) {
            throw new NullPointerException("rectangle");
        }
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? new LRange(lRectangle.x, lRectangle.x + lRectangle.width) : new LRange(lRectangle.y, lRectangle.y + lRectangle.height);
    }

    public static final int get(Point point, Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? point.x : point.y;
    }

    public static final int getStart(Rectangle rect, Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? rect.x : rect.y;
    }

    public static final int getEnd(Rectangle rect, Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? rect.x + rect.width : rect.y + rect.height;
    }

    public static final int getSize(Rectangle rect, Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? rect.width : rect.height;
    }

    public static final int get(MouseEvent point, Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? point.x : point.y;
    }

    public static final Rectangle toSWT(LRectangle rect) {
        if (rect.x > Integer.MAX_VALUE || rect.y > Integer.MAX_VALUE || rect.width > Integer.MAX_VALUE || rect.height > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public static final LRectangle toNatTable(Rectangle rect) {
        return new LRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public static final Point toSWT(LPoint lPoint) {
        if (lPoint.x > Integer.MAX_VALUE || lPoint.y > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return new Point((int)lPoint.x, (int)lPoint.y);
    }

    public static final int getPixel(MouseEvent event, Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? event.x : event.y;
    }

    public static final int toSWT(HorizontalAlignment alignment) {
        switch (alignment) {
            case LEFT: {
                return 16384;
            }
            case CENTER: {
                return 0x1000000;
            }
            case RIGHT: {
                return 131072;
            }
        }
        throw new IllegalStateException();
    }

    public static final int toSWT(BorderStyle.LineStyle lineStyle) {
        switch (lineStyle) {
            case SOLID: {
                return 1;
            }
            case DASHED: {
                return 2;
            }
            case DOTTED: {
                return 3;
            }
            case DASHDOT: {
                return 4;
            }
            case DASHDOTDOT: {
                return 5;
            }
        }
        throw new IllegalStateException();
    }
}

