/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.docmlet.tex.core.ast.Comment;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.Dummy;
import org.eclipse.statet.docmlet.tex.core.ast.Embedded;
import org.eclipse.statet.docmlet.tex.core.ast.Environment;
import org.eclipse.statet.docmlet.tex.core.ast.Group;
import org.eclipse.statet.docmlet.tex.core.ast.Label;
import org.eclipse.statet.docmlet.tex.core.ast.Math;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstVisitor;
import org.eclipse.statet.docmlet.tex.core.ast.Text;
import org.eclipse.statet.docmlet.tex.core.ast.Verbatim;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.ecommons.runtime.core.util.MessageBuilder;
import org.eclipse.statet.internal.docmlet.tex.core.model.ProblemMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.BasicProblem;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public class LtxProblemAstVisitor
extends TexAstVisitor {
    private static final int ENV_LABEL_LIMIT = 20;
    private static final int BUFFER_SIZE = 100;
    private SourceUnit sourceUnit = (SourceUnit)ObjectUtils.nonNullLateInit();
    private SourceContent sourceContent = (SourceContent)ObjectUtils.nonNullLateInit();
    private ProblemRequestor currentRequestor = (ProblemRequestor)ObjectUtils.nonNullLateInit();
    private final MessageBuilder messageBuilder = new MessageBuilder();
    private final List<Problem> problemBuffer = new ArrayList<Problem>(100);

    public void run(TexSourceUnit su, SourceContent content, TexAstNode node, ProblemRequestor requestor) {
        try {
            try {
                this.sourceUnit = (SourceUnit)ObjectUtils.nonNullAssert((Object)su);
                this.sourceContent = (SourceContent)ObjectUtils.nonNullAssert((Object)content);
                this.currentRequestor = (ProblemRequestor)ObjectUtils.nonNullAssert((Object)requestor);
                node.acceptInTex(this);
                if (this.problemBuffer.size() > 0) {
                    this.currentRequestor.acceptProblems("Ltx", this.problemBuffer);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                this.problemBuffer.clear();
                this.sourceUnit = null;
                this.currentRequestor = null;
            }
        }
        finally {
            this.problemBuffer.clear();
            this.sourceUnit = null;
            this.currentRequestor = null;
        }
    }

    @Override
    public void visit(SourceComponent node) throws InvocationTargetException {
        node.acceptInTexChildren(this);
    }

    @Override
    public void visit(Group node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFF;
        if (code == 8468) {
            if (node.getParent() instanceof ControlNode) {
                this.addProblem(2, code, node.getText() == "{" ? ProblemMessages.Ast_ReqArgument_NotClosed_message : ProblemMessages.Ast_OptArgument_NotClosed_Opt_message, node.getStartOffset(), node.getStartOffset() + 1);
            } else {
                this.addProblem(2, code, node.getText() == "{" ? ProblemMessages.Ast_CurlyBracket_NotClosed_message : ProblemMessages.Ast_SquareBracket_NotClosed_message, node.getStartOffset(), node.getStartOffset() + 1);
            }
        }
        node.acceptInTexChildren(this);
    }

    @Override
    public void visit(Environment node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFF;
        switch (code) {
            case 8465: {
                ControlNode beginNode = node.getBeginNode();
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Ast_Env_NotClosed_message, (Object)this.limit(node.getText(), 20)), beginNode.getStartOffset(), beginNode.getEndOffset());
                break;
            }
            case 8467: {
                ControlNode beginNode = node.getBeginNode();
                String c = node.getText();
                c = c == "[" ? "\\]" : (c == "(" ? "\\)" : null);
                if (c == null) break;
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Ast_Math_NotClosed_message, (Object)c), beginNode.getStartOffset(), beginNode.getEndOffset());
            }
        }
        node.acceptInTexChildren(this);
    }

    @Override
    public void visit(ControlNode node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFF;
        switch (code) {
            case 4369: {
                this.addProblem(2, code, node.getText().equals("begin") ? ProblemMessages.Ast_Env_MissingName_Begin_message : ProblemMessages.Ast_Env_MissingName_End_message, node.getStartOffset(), node.getEndOffset());
                break;
            }
            case 8721: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Ast_Env_NotOpened_message, (Object)this.limit(node.getChild(0).getChild(0).getText(), 20)), node.getStartOffset(), node.getEndOffset());
                break;
            }
            case 4370: {
                this.addProblem(2, code, ProblemMessages.Ast_Verbatim_MissingSep_message, node.getEndOffset() - 1, node.getEndOffset());
            }
        }
        node.acceptInTexChildren(this);
    }

    @Override
    public void visit(Text node) throws InvocationTargetException {
    }

    @Override
    public void visit(Label node) throws InvocationTargetException {
    }

    @Override
    public void visit(Math node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFF;
        switch (code) {
            case 8467: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Ast_Math_NotClosed_message, (Object)node.getText()), node.getStartOffset(), node.getStartOffset() + node.getText().length());
            }
        }
        node.acceptInTexChildren(this);
    }

    @Override
    public void visit(Verbatim node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFF;
        switch (code) {
            case 8466: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Ast_Verbatim_NotClosed_message, (Object)this.sourceContent.getString(node.getStartOffset() - 1, node.getStartOffset())), node.getEndOffset() - 1, node.getEndOffset());
            }
        }
    }

    @Override
    public void visit(Comment node) throws InvocationTargetException {
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFF;
        switch (code) {
            case 8724: {
                this.addProblem(2, code, node.getText() == "{" ? ProblemMessages.Ast_CurlyBracket_NotOpened_message : ProblemMessages.Ast_SquareBracket_NotOpened_message, node.getStartOffset(), node.getStartOffset() + 1);
            }
        }
    }

    @Override
    public void visit(Embedded node) throws InvocationTargetException {
    }

    protected final @Nullable String limit(@Nullable String label, int limit) {
        if (label != null && label.length() > limit) {
            return String.valueOf(label.substring(0, limit)) + '\u2026';
        }
        return label;
    }

    protected final void addProblem(int severity, int code, String message, int startOffset, int endOffset) {
        if (startOffset < this.sourceContent.getStartOffset()) {
            startOffset = this.sourceContent.getStartOffset();
        }
        if (endOffset > this.sourceContent.getEndOffset()) {
            endOffset = this.sourceContent.getEndOffset();
        }
        this.problemBuffer.add((Problem)new BasicProblem("Ltx", severity, code, message, startOffset, endOffset));
        if (this.problemBuffer.size() >= 100) {
            this.currentRequestor.acceptProblems("Ltx", this.problemBuffer);
            this.problemBuffer.clear();
        }
    }
}

