/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.preferences.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.internal.ecommons.preferences.core.Messages;
import org.eclipse.statet.jcommons.collections.CopyOnWriteList;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImListBuilder;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class DefaultPreferenceSetService
implements PreferenceSetService,
ISchedulingRule,
Disposable {
    private static final int MS_NS = 1000000;
    private static final int MIN_WAIT_NS = 50000000;
    private static final int AUTO_WAIT_NS = 200000000;
    private static final int TOLERANCE_NS = 25000000;
    private static final String DISPOSE_SOURCE = "disposed";
    private final Set<String> pauseIds = new HashSet<String>();
    private final CopyOnWriteList<ChangeListenerItem> listeners = new CopyOnWriteList();
    private final Map<IScopeContext, ContextItem> contexts = new HashMap<IScopeContext, ContextItem>();
    private @Nullable ImList<ContextItem> contextList;
    private final Job defaultJob = new NotifyJob(null);
    private volatile long minStamp;
    private volatile long scheduledStamp;
    private final Map<IScopeContext, ImList<NodeItem>> processMap = new HashMap<IScopeContext, ImList<NodeItem>>();
    private final ImListBuilder<?> processListBuilder = new ImListBuilder();
    private final Event processEvent = new Event();

    public synchronized void dispose() {
        this.pauseIds.add(DISPOSE_SOURCE);
    }

    @Override
    public synchronized boolean pause(String sourceId) {
        if (this.pauseIds.isEmpty()) {
            this.defaultJob.cancel();
        }
        return this.pauseIds.add(sourceId);
    }

    private boolean removePause(String sourceId) {
        return this.pauseIds.remove(sourceId) && this.pauseIds.isEmpty();
    }

    @Override
    public synchronized void resume(String sourceId) {
        if (this.removePause(sourceId)) {
            this.scheduledStamp = System.nanoTime() + 50000000L;
            this.defaultJob.schedule(75L);
        }
    }

    private synchronized void onPreferenceChange() {
        if (!this.pauseIds.isEmpty()) {
            long time = System.nanoTime() + 50000000L;
            if (time > this.minStamp) {
                this.minStamp = time;
            }
            return;
        }
        long time = System.nanoTime() + 200000000L;
        if (time > this.minStamp) {
            this.minStamp = time;
        }
        if (time > this.scheduledStamp + 25000000L) {
            this.defaultJob.cancel();
            this.scheduledStamp = time;
            this.defaultJob.schedule(225L);
        }
    }

    private synchronized boolean isOkToRun(long time) {
        if (!this.pauseIds.isEmpty()) {
            return false;
        }
        if (time < this.minStamp) {
            this.scheduledStamp = this.minStamp;
            this.defaultJob.schedule((this.minStamp - System.nanoTime() + 25000000L) / 1000000L);
            return false;
        }
        return true;
    }

    @Override
    public Job createResumeJob(String key) {
        return new NotifyJob(key);
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextItem getContextItem(IScopeContext context) {
        Map<IScopeContext, ContextItem> map = this.contexts;
        synchronized (map) {
            ContextItem contextItem = this.contexts.get(context);
            if (contextItem == null) {
                contextItem = new ContextItem(context);
                this.contexts.put(context, contextItem);
                this.contextList = null;
            }
            return contextItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImList<ContextItem> getContextItems() {
        Map<IScopeContext, ContextItem> map = this.contexts;
        synchronized (map) {
            if (this.contextList == null) {
                this.contextList = ImCollections.toList(this.contexts.values());
            }
            return this.contextList;
        }
    }

    public void watch(IScopeContext context, ImSet<String> qualifiers) {
        this.getContextItem(context).watch((ImCollection<String>)qualifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(PreferenceSetService.ChangeListener listener, ImList<IScopeContext> contexts, ImSet<String> qualifiers) {
        block9: {
            if (listener == null) {
                throw new NullPointerException("listener");
            }
            if (contexts == null) {
                throw new NullPointerException("contexts");
            }
            if (qualifiers == null) {
                throw new NullPointerException("qualifiers");
            }
            CopyOnWriteList<ChangeListenerItem> copyOnWriteList = this.listeners;
            synchronized (copyOnWriteList) {
                ChangeListenerItem item = new ChangeListenerItem(listener, contexts, qualifiers);
                ImList l = this.listeners.toList();
                int i = 0;
                while (i < l.size()) {
                    ChangeListenerItem iItem = (ChangeListenerItem)l.get(i);
                    if (iItem.getListener() == listener) {
                        this.listeners.set(i, (Object)item);
                        break block9;
                    }
                    ++i;
                }
                this.listeners.add((Object)item);
            }
        }
        for (IScopeContext context : contexts) {
            if (context instanceof DefaultScope) continue;
            this.watch(context, qualifiers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(PreferenceSetService.ChangeListener listener) {
        CopyOnWriteList<ChangeListenerItem> copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            ImList l = this.listeners.toList();
            int i = 0;
            while (i < l.size()) {
                if (((ChangeListenerItem)l.get(i)).getListener() == listener) {
                    this.listeners.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void process(IProgressMonitor monitor) {
        @NonNull Map<IScopeContext, ImList<NodeItem>> map = this.processMap;
        long time = System.nanoTime();
        if (!this.isOkToRun(time)) {
            return;
        }
        ImList<ContextItem> contextItems = this.getContextItems();
        ImListBuilder<?> items = this.processListBuilder;
        items.clear();
        boolean merge = !map.isEmpty();
        for (ContextItem contextItem : contextItems) {
            ImList<NodeItem> oldItems;
            contextItem.check((List<NodeItem>)items);
            if (items.isEmpty()) continue;
            if (merge && (oldItems = map.get(contextItem.getContext())) != null) {
                items.addAll(oldItems);
            }
            map.put(contextItem.getContext(), (ImList<NodeItem>)items.build());
            items.clear();
            if (this.isOkToRun(time)) continue;
            return;
        }
        try {
            Event event = this.processEvent;
            ImList listeners = this.listeners.toList();
            for (ChangeListenerItem listener : listeners) {
                for (IScopeContext context : listener.getContexts()) {
                    ImList<NodeItem> list = map.get(context);
                    if (list == null) continue;
                    for (NodeItem nodeItem : list) {
                        if (!listener.getQualifiers().contains((Object)nodeItem.getQualifier())) continue;
                        event.add(nodeItem.getQualifier(), nodeItem.getChangedKeys());
                    }
                }
                if (event.isEmpty()) continue;
                listener.getListener().preferenceChanged(event);
                event.reset();
            }
        }
        finally {
            map.clear();
        }
    }

    private static class ChangeListenerItem {
        private final PreferenceSetService.ChangeListener listener;
        private final ImList<IScopeContext> contexts;
        private final ImSet<String> qualifiers;

        public ChangeListenerItem(PreferenceSetService.ChangeListener listener, ImList<IScopeContext> contexts, ImSet<String> qualifiers) {
            this.listener = listener;
            this.contexts = contexts;
            this.qualifiers = qualifiers;
        }

        public PreferenceSetService.ChangeListener getListener() {
            return this.listener;
        }

        public ImList<IScopeContext> getContexts() {
            return this.contexts;
        }

        public ImSet<String> getQualifiers() {
            return this.qualifiers;
        }
    }

    private class ContextItem {
        private final IScopeContext context;
        private final ConcurrentHashMap<String, NodeItem> nodes = new ConcurrentHashMap();

        public ContextItem(IScopeContext context) {
            this.context = context;
        }

        public IScopeContext getContext() {
            return this.context;
        }

        public void watch(ImCollection<String> qualifiers) {
            for (String qualifier : qualifiers) {
                if (this.nodes.contains(qualifier)) continue;
                this.nodes.putIfAbsent(qualifier, new NodeItem(this.context, qualifier));
            }
        }

        public void check(List<NodeItem> items) {
            for (NodeItem nodeItem : this.nodes.values()) {
                if (!nodeItem.check()) continue;
                items.add(nodeItem);
            }
        }
    }

    private class Event
    implements PreferenceSetService.ChangeEvent {
        private final IdentityHashMap<String, ImList<String>> qualifierKeyMap = new IdentityHashMap(32);

        private Event() {
        }

        @Override
        public boolean contains(String qualifier) {
            return this.qualifierKeyMap.containsKey(qualifier);
        }

        @Override
        public boolean contains(String qualifier, String key) {
            block6: {
                ImList<String> events = this.qualifierKeyMap.get(qualifier);
                if (events == null) break block6;
                if (key.charAt(key.length() - 1) == '*') {
                    key = key.substring(0, key.length() - 1);
                    int i = 0;
                    while (i < events.size()) {
                        if (((String)events.get(i)).startsWith(key)) {
                            return true;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < events.size()) {
                        if (((String)events.get(i)).equals(key)) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean contains(Preference<?> pref) {
            return this.contains(pref.getQualifier(), pref.getKey());
        }

        @Override
        public ImList<String> getKeys(String qualifier) {
            return this.qualifierKeyMap.get(qualifier);
        }

        public void add(String qualifier, ImList<String> keys) {
            ImList<String> present = this.qualifierKeyMap.put(qualifier, keys);
            if (present != null) {
                this.qualifierKeyMap.put(qualifier, (ImList<String>)ImCollections.concatList(present, keys));
            }
        }

        public boolean isEmpty() {
            return this.qualifierKeyMap.isEmpty();
        }

        public void reset() {
            this.qualifierKeyMap.clear();
        }
    }

    private class NodeItem
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final IScopeContext context;
        private final String qualifier;
        private final IEclipsePreferences node;
        private final List<String> newKeys = new ArrayList<String>();
        private ImList<String> checkedKeys = ImCollections.emptyList();

        public NodeItem(IScopeContext context, String qualifier) {
            this.context = context;
            this.qualifier = qualifier;
            this.node = context.getNode(qualifier);
            this.node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public IScopeContext getContext() {
            return this.context;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            DefaultPreferenceSetService.this.onPreferenceChange();
            List<String> list = this.newKeys;
            synchronized (list) {
                this.newKeys.add(event.getKey());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean check() {
            List<String> list = this.newKeys;
            synchronized (list) {
                block4: {
                    this.checkedKeys = ImCollections.toList(this.newKeys);
                    if (!this.checkedKeys.isEmpty()) break block4;
                    return false;
                }
                this.newKeys.clear();
                return true;
            }
        }

        public ImList<String> getChangedKeys() {
            return this.checkedKeys;
        }
    }

    private class NotifyJob
    extends Job {
        private final String pauseKey;

        public NotifyJob(String pauseKey) {
            super(Messages.Preferences_Notifier_title);
            this.pauseKey = pauseKey;
            this.setSystem(true);
            this.setPriority(20);
            this.setRule(DefaultPreferenceSetService.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (this.pauseKey != null) {
                DefaultPreferenceSetService defaultPreferenceSetService = DefaultPreferenceSetService.this;
                synchronized (defaultPreferenceSetService) {
                    if (!DefaultPreferenceSetService.this.removePause(this.pauseKey)) {
                        return Status.OK_STATUS;
                    }
                }
            }
            DefaultPreferenceSetService.this.process(monitor);
            return Status.OK_STATUS;
        }
    }
}

