/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.layer;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.layer.CellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.layer.NatLayerPainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class NatGridLayerPainter
extends NatLayerPainter {
    private final Color gridColor;

    public NatGridLayerPainter(NatTable natTable) {
        this(natTable, GUIHelper.COLOR_GRAY);
    }

    public NatGridLayerPainter(NatTable natTable, Color gridColor) {
        super(natTable);
        this.gridColor = gridColor;
    }

    @Override
    protected void paintBackground(ILayer natLayer, GC gc, long xOffset, long yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        super.paintBackground(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
        gc.setForeground(this.gridColor);
        this.drawHorizontalLines(natLayer, gc, rectangle);
        this.drawVerticalLines(natLayer, gc, rectangle);
    }

    private void drawHorizontalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        int startX = rectangle.x;
        int endX = rectangle.x + rectangle.width;
        ILayerDim dim = natLayer.getDim(Orientation.VERTICAL);
        long endPosition = CellLayerPainter.getEndPosition(dim, rectangle.y + rectangle.height);
        long position = dim.getPositionByPixel(rectangle.y);
        while (position < endPosition) {
            int size = dim.getPositionSize(position);
            if (size > 0) {
                int y = GraphicsUtils.safe(dim.getPositionStart(position) + (long)size - 1L);
                gc.drawLine(startX, y, endX, y);
            }
            ++position;
        }
    }

    private void drawVerticalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        int startY = rectangle.y;
        int endY = rectangle.y + rectangle.height;
        ILayerDim dim = natLayer.getDim(Orientation.HORIZONTAL);
        long endPosition = CellLayerPainter.getEndPosition(dim, rectangle.x + rectangle.width);
        long position = dim.getPositionByPixel(rectangle.x);
        while (position < endPosition) {
            int size = dim.getPositionSize(position);
            if (size > 0) {
                int x = GraphicsUtils.safe(dim.getPositionStart(position) + (long)size - 1L);
                gc.drawLine(x, startY, x, endY);
            }
            ++position;
        }
    }
}

