/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.base.core.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.issues.core.TaskPriority;
import org.eclipse.statet.ltk.issues.core.TaskTag;
import org.eclipse.statet.ltk.issues.core.impl.BasicTaskTag;

public class TaskTagsPreferences {
    public static final String GROUP_ID = "statet.task_tags";
    private static final String KEY_TAGS = "TaskTags.keyword";
    private static final String KEY_PRIORITIES = "TaskTags.priority";
    public static final Preference.StringArrayPref PREF_TAGS = new Preference.StringArrayPref("org.eclipse.statet.ide.core/managment", "TaskTags.keyword");
    public static final Preference.EnumListPref<TaskPriority> PREF_PRIORITIES = new Preference.EnumListPref("org.eclipse.statet.ide.core/managment", "TaskTags.priority", TaskPriority.class);
    private final ImList<TaskTag> taskTags;

    public static String[] loadTagsOnly(PreferenceAccess prefs) {
        return (String[])prefs.getPreferenceValue((Preference)PREF_TAGS);
    }

    public TaskTagsPreferences(Collection<? extends TaskTag> taskTags) {
        this.taskTags = ImCollections.toList(taskTags);
    }

    public TaskTagsPreferences() {
        this((Collection<? extends TaskTag>)ImCollections.newList((Object[])new BasicTaskTag[]{new BasicTaskTag("TODO", TaskPriority.NORMAL), new BasicTaskTag("FIXME", TaskPriority.NORMAL)}));
    }

    public TaskTagsPreferences(PreferenceAccess prefs) {
        String[] keywords = (String[])prefs.getPreferenceValue((Preference)PREF_TAGS);
        List priorities = (List)prefs.getPreferenceValue(PREF_PRIORITIES);
        if (keywords.length == priorities.size()) {
            Object[] array = new TaskTag[keywords.length];
            int i = 0;
            while (i < array.length) {
                array[i] = new BasicTaskTag(keywords[i], (TaskPriority)priorities.get(i));
                ++i;
            }
            this.taskTags = ImCollections.newList((Object[])array);
        } else {
            this.taskTags = ImCollections.emptyList();
        }
    }

    public String[] getTags() {
        String[] array = new String[this.taskTags.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = ((TaskTag)this.taskTags.get(i)).getKeyword();
            ++i;
        }
        return array;
    }

    public TaskPriority[] getPriorities() {
        TaskPriority[] array = new TaskPriority[this.taskTags.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = ((TaskTag)this.taskTags.get(i)).getPriority();
            ++i;
        }
        return array;
    }

    public List<TaskTag> getTaskTags() {
        return this.taskTags;
    }

    public Map<Preference<?>, Object> addPreferencesToMap(Map<Preference<?>, Object> map) {
        map.put((Preference<?>)PREF_TAGS, this.getTags());
        map.put((Preference<?>)PREF_PRIORITIES, ImCollections.newList((Object[])this.getPriorities()));
        return map;
    }

    public Map<Preference<?>, Object> getPreferencesMap() {
        return this.addPreferencesToMap(new HashMap(2));
    }
}

