/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ImArrayIdentitySubList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonList;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class ImArraySubList<E>
extends AbstractImList<E>
implements ImList<E>,
RandomAccess {
    private final E[] array;
    private final int offset;
    private final int size;

    public ImArraySubList(E[] array, int fromIndex, int toIndex) {
        this.array = array;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.indexOf(iter.next()) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[this.offset + index];
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null) {
            int toIndex = this.offset + this.size;
            int i = this.offset;
            while (i < toIndex) {
                if (this.array[i] == null) {
                    return i - this.offset;
                }
                ++i;
            }
            return -1;
        }
        int toIndex = this.offset + this.size;
        int i = this.offset;
        while (i < toIndex) {
            if (o.equals(this.array[i])) {
                return i - this.offset;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        if (o == null) {
            int i = this.offset + this.size - 1;
            while (i >= this.offset) {
                if (this.array[i] == null) {
                    return i - this.offset;
                }
                --i;
            }
            return -1;
        }
        int i = this.offset + this.size - 1;
        while (i >= this.offset) {
            if (o.equals(this.array[i])) {
                return i - this.offset;
            }
            --i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new Iter(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return new Iter(index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.array, this.offset, this.offset + this.size, 1040);
    }

    @Override
    public ImList<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size) {
            throw new IndexOutOfBoundsException("fromIndex= " + fromIndex + ", toIndex= " + toIndex + ", size= " + this.size);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex: fromIndex= " + fromIndex + ", toIndex= " + toIndex);
        }
        int l = toIndex - fromIndex;
        if (l == this.size) {
            return this;
        }
        if (l == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (l == 1) {
            return new ImSingletonList<E>(this.array[this.offset + fromIndex]);
        }
        return new ImArraySubList<E>(this.array, this.offset + fromIndex, this.offset + toIndex);
    }

    @Override
    public Object[] toArray() {
        Object[] dest = new Object[this.size];
        System.arraycopy(this.array, this.offset, dest, 0, this.size);
        return dest;
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        if (dest.length < this.size) {
            return Arrays.copyOfRange(this.array, this.offset, this.offset + this.size, dest.getClass());
        }
        System.arraycopy(this.array, this.offset, dest, 0, this.size);
        if (dest.length > this.size) {
            dest[this.size] = null;
        }
        return dest;
    }

    @Override
    public void copyTo(Object[] dest, int destPos) {
        System.arraycopy(this.array, this.offset, dest, destPos, this.size);
    }

    @Override
    public void copyTo(int srcPos, Object[] dest, int destPos, int length) {
        System.arraycopy(this.array, this.offset + srcPos, dest, destPos, length);
    }

    @Override
    public ImList<E> toImList() {
        return this;
    }

    @Override
    public ImIdentityList<E> toImIdentityList() {
        return new ImArrayIdentitySubList<E>(this.array, this.offset, this.offset + this.size);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int toIndex = this.offset + this.size;
        int i = this.offset;
        while (i < toIndex) {
            hashCode = 31 * hashCode + (this.array[i] != null ? this.array[i].hashCode() : 0);
            ++i;
        }
        return hashCode;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List other = (List)obj;
            if (this.size != other.size()) {
                return false;
            }
            ListIterator otherIter = other.listIterator();
            int toIndex = this.offset + this.size;
            int i = this.offset;
            while (i < toIndex) {
                if (!Objects.equals(this.array[i], otherIter.next())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private class Iter
    extends AbstractImList.AbstractImListIter<E> {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ImArraySubList.this.size;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public E next() {
            if (this.cursor >= ImArraySubList.this.size) {
                throw new NoSuchElementException();
            }
            return ImArraySubList.this.array[ImArraySubList.this.offset + this.cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            if (this.cursor <= 0 || ImArraySubList.this.size <= 0) {
                throw new NoSuchElementException();
            }
            return ImArraySubList.this.array[ImArraySubList.this.offset + --this.cursor];
        }
    }
}

