/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.nico.core.Messages;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.ToolCommandHandler;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.jcommons.ts.core.util.ToolCommandHandlerUtils;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;

public class HistoryOperationsHandler
implements ToolCommandHandler {
    public static final String LOAD_HISTORY_ID = "console/loadHistory";
    public static final String SAVE_HISTORY_ID = "console/saveHistory";
    public static final String ADDTO_HISTORY_ID = "console/addtoHistory";

    public Status execute(String id, ToolService service, Map<String, Object> data, ProgressMonitor m) {
        if (service instanceof ConsoleService) {
            ConsoleService console = (ConsoleService)service;
            if (id.equals(LOAD_HISTORY_ID)) {
                return this.loadHistory(console, data, m);
            }
            if (id.equals(SAVE_HISTORY_ID)) {
                return this.saveHistory(console, data, m);
            }
            if (id.equals(ADDTO_HISTORY_ID)) {
                String item = (String)ToolCommandHandlerUtils.getCheckedData(data, (String)"text", String.class, (boolean)true);
                console.getTool().getHistory().addCommand(item, console.getController().getCurrentSubmitType());
                return Status.OK_STATUS;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected Status loadHistory(ConsoleService tools, Map<String, Object> data, ProgressMonitor m) {
        try {
            CoreException fileException = null;
            IFileStore fileStore = null;
            String filename = (String)ToolCommandHandlerUtils.getCheckedData(data, (String)"filename", String.class, (boolean)true);
            ToolWorkspace workspaceData = tools.getWorkspaceData();
            try {
                fileStore = workspaceData.toFileStore(filename);
            }
            catch (CoreException e) {
                fileException = e;
            }
            Object status = fileStore == null ? new ErrorStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.ToolController_FileOperation_error_CannotResolve_message, (Object)filename), (Throwable)fileException) : tools.getTool().getHistory().load(fileStore, workspaceData.getEncoding(), false, m);
            tools.handleStatus((Status)status, m);
            return status;
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
    }

    protected Status saveHistory(ConsoleService tools, Map<String, Object> data, ProgressMonitor m) {
        try {
            CoreException fileException = null;
            IFileStore fileStore = null;
            String filename = (String)ToolCommandHandlerUtils.getCheckedData(data, (String)"filename", String.class, (boolean)true);
            ToolWorkspace workspaceData = tools.getWorkspaceData();
            try {
                fileStore = workspaceData.toFileStore(filename);
            }
            catch (CoreException e) {
                fileException = e;
            }
            Object status = fileStore == null ? new ErrorStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.ToolController_FileOperation_error_CannotResolve_message, (Object)filename), (Throwable)fileException) : tools.getTool().getHistory().save(fileStore, 0, workspaceData.getEncoding(), false, m);
            tools.handleStatus((Status)status, m);
            return status;
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
    }
}

