/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.util.AbstractFragmentDocument;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.impl.BasicWorkingBuffer;

@NonNullByDefault
public abstract class GenericConsoleSourceUnit
implements SourceUnit {
    private final String id;
    private final ElementName name;
    private final AbstractFragmentDocument document;
    private int counter = 0;

    public GenericConsoleSourceUnit(String id, AbstractFragmentDocument document) {
        this.id = id;
        this.name = new ElementName(){

            public int getType() {
                return 17;
            }

            public String getDisplayName() {
                return GenericConsoleSourceUnit.this.id;
            }

            public String getSegmentName() {
                return GenericConsoleSourceUnit.this.id;
            }

            public @Nullable ElementName getNextSegment() {
                return null;
            }
        };
        this.document = document;
    }

    public WorkingContext getWorkingContext() {
        return Ltk.EDITOR_CONTEXT;
    }

    public @Nullable SourceUnit getUnderlyingUnit() {
        return null;
    }

    public boolean isSynchronized() {
        return true;
    }

    public int getElementType() {
        return 640;
    }

    public ElementName getElementName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean exists() {
        return this.counter > 0;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        return true;
    }

    public @Nullable Object getResource() {
        return null;
    }

    protected final AbstractFragmentDocument getDocument() {
        return this.document;
    }

    public AbstractDocument getDocument(@Nullable IProgressMonitor monitor) {
        return this.document;
    }

    public long getContentStamp(IProgressMonitor monitor) {
        return this.document.getModificationStamp();
    }

    public SourceContent getContent(IProgressMonitor monitor) {
        return BasicWorkingBuffer.createContentFromDocument((IDocument)this.document);
    }

    public final synchronized void connect(IProgressMonitor monitor) {
        ++this.counter;
    }

    public final synchronized void disconnect(IProgressMonitor monitor) {
        --this.counter;
    }

    public synchronized boolean isConnected() {
        return this.counter > 0;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        return null;
    }

    public String toString() {
        return String.valueOf(this.getModelTypeId()) + '/' + this.getWorkingContext() + ": " + this.getId();
    }
}

