/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.data;

import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.r.core.rsource.RLexer;
import org.eclipse.statet.r.core.rsource.RTerminal;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RComplexStore;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RRawStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;

public class RValueValidator {
    private static final byte INVALID = 0;
    private static final byte UNKNOWN = 1;
    private static final byte VALID = 2;
    private final RLexer lexer = new RLexer(32);
    private final RLogicalStore logiValue = DefaultRObjectFactory.INSTANCE.createLogiData(1L);
    private final RIntegerStore intValue = DefaultRObjectFactory.INSTANCE.createIntData(1L);
    private final RNumericStore numValue = DefaultRObjectFactory.INSTANCE.createNumData(1L);
    private final RComplexStore complexValue = DefaultRObjectFactory.INSTANCE.createCplxData(1L);
    private final RCharacterStore charValue = DefaultRObjectFactory.INSTANCE.createCharData(1L);
    private final RRawStore rawValue = DefaultRObjectFactory.INSTANCE.createRawData(1L);
    private RValueFormatter formatter;

    private int addSign(int sign, int value) {
        return sign == -1 ? -value : value;
    }

    private double addSign(int sign, double value) {
        return sign == -1 ? -value : value;
    }

    public boolean isValid(RStore<?> store, String expression) {
        switch (store.getStoreType()) {
            case 1: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: {
                        return true;
                    }
                    case 3: {
                        return this.real2logi();
                    }
                }
                return false;
            }
            case 2: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                    case 3: {
                        return this.real2int();
                    }
                }
                return false;
            }
            case 3: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
            case 6: {
                expression = expression.trim();
                switch (this.parseSimpleHexInt(expression)) {
                    case 2: {
                        return this.int2raw();
                    }
                    case 1: {
                        switch (this.parseValueType(expression)) {
                            case 1: {
                                return !this.logiValue.isNA(0);
                            }
                            case 3: {
                                return expression.startsWith("0x") && this.real2int() && this.int2raw();
                            }
                            case 2: {
                                return this.int2raw();
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
            case 10: {
                return this.parseFactorLevel(expression, ((RFactorStore)store).getLevels());
            }
        }
        return false;
    }

    public RStore<?> toRData(RStore<?> store, String expression) {
        switch (store.getStoreType()) {
            case 1: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: {
                        return this.logiValue;
                    }
                    case 3: {
                        if (this.real2logi()) {
                            return this.logiValue;
                        }
                        return null;
                    }
                }
                return null;
            }
            case 2: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: {
                        return this.logiValue;
                    }
                    case 2: {
                        return this.intValue;
                    }
                    case 3: {
                        if (this.real2int()) {
                            return this.intValue;
                        }
                        return null;
                    }
                }
                return null;
            }
            case 3: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: {
                        return this.logiValue;
                    }
                    case 2: {
                        return this.intValue;
                    }
                    case 3: {
                        return this.numValue;
                    }
                }
                return null;
            }
            case 4: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: {
                        return this.logiValue;
                    }
                    case 2: {
                        return this.intValue;
                    }
                    case 3: {
                        return this.numValue;
                    }
                    case 4: {
                        return this.complexValue;
                    }
                }
                return null;
            }
            case 5: {
                expression = expression.trim();
                switch (this.parseValueType(expression)) {
                    case 1: {
                        return this.logiValue;
                    }
                    case 2: {
                        return this.intValue;
                    }
                    case 3: {
                        return this.numValue;
                    }
                    case 4: {
                        return this.complexValue;
                    }
                    case 5: {
                        return this.charValue;
                    }
                }
                return null;
            }
            case 6: {
                expression = expression.trim();
                switch (this.parseSimpleHexInt(expression)) {
                    case 2: {
                        if (this.int2raw()) {
                            return this.rawValue;
                        }
                        return null;
                    }
                    case 1: {
                        switch (this.parseValueType(expression)) {
                            case 1: {
                                if (!this.logiValue.isNA(0)) {
                                    this.rawValue.setRaw(0, this.logiValue.getRaw(0));
                                    return this.rawValue;
                                }
                                return null;
                            }
                            case 3: {
                                if (expression.startsWith("0x") && this.real2int() && this.int2raw()) {
                                    return this.rawValue;
                                }
                                return null;
                            }
                            case 2: {
                                if (this.int2raw()) {
                                    return this.rawValue;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 10: {
                if (this.parseFactorLevel(expression, ((RFactorStore)store).getLevels())) {
                    return this.charValue;
                }
                return null;
            }
        }
        return null;
    }

    private byte parseValueType(String expression) {
        int sign;
        this.lexer.reset((TextParserInput)new StringParserInput(expression).init());
        RTerminal nextToken = this.lexer.next();
        switch (nextToken) {
            case PLUS: {
                sign = 1;
                nextToken = this.lexer.next();
                break;
            }
            case MINUS: {
                sign = -1;
                nextToken = this.lexer.next();
                break;
            }
            default: {
                sign = 0;
            }
        }
        if ((this.lexer.getFlags() & 0x10000) != 0) {
            return 0;
        }
        switch (nextToken) {
            case TRUE: {
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.logiValue.setLogi(0, true);
                        return 1;
                    }
                }
                return 0;
            }
            case FALSE: {
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.logiValue.setLogi(0, false);
                        return 1;
                    }
                }
                return 0;
            }
            case NA: {
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.logiValue.setNA(0);
                        return 1;
                    }
                }
                return 0;
            }
            case NUM_INT: {
                int value = (int)this.lexer.getNumValue();
                switch (this.lexer.next()) {
                    case EOF: {
                        this.intValue.setInt(0, this.addSign(sign, value));
                        return 2;
                    }
                }
                return 0;
            }
            case NA_INT: {
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.intValue.setNA(0);
                        return 2;
                    }
                }
                return 0;
            }
            case NUM_NUM: 
            case INF: {
                double value = this.lexer.getNumValue();
                block33 : switch (this.lexer.next()) {
                    case EOF: {
                        this.numValue.setNum(0, this.addSign(sign, value));
                        return 3;
                    }
                    case PLUS: 
                    case MINUS: {
                        this.complexValue.setNum(0, this.addSign(sign, value));
                        sign = this.lexer.getType() == RTerminal.PLUS ? 1 : -1;
                        nextToken = this.lexer.next();
                        if ((this.lexer.getFlags() & 0x10000) != 0) {
                            return 0;
                        }
                        switch (nextToken) {
                            case NUM_CPLX: {
                                value = this.lexer.getNumValue();
                                switch (this.lexer.next()) {
                                    case EOF: {
                                        this.complexValue.setCplx(0, this.complexValue.getCplxRe(0), this.addSign(sign, value));
                                        return 4;
                                    }
                                }
                                break block33;
                            }
                        }
                        break;
                    }
                }
                return 0;
            }
            case NAN: {
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.numValue.setNum(0, Double.NaN);
                        return 3;
                    }
                }
                return 0;
            }
            case NA_REAL: {
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.numValue.setNA(0);
                        return 3;
                    }
                }
                return 0;
            }
            case NUM_CPLX: {
                double value = this.lexer.getNumValue();
                switch (this.lexer.next()) {
                    case EOF: {
                        this.complexValue.setCplx(0, 0.0, this.addSign(sign, value));
                        return 4;
                    }
                }
                return 0;
            }
            case NA_CPLX: {
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.complexValue.setNA(0);
                        return 4;
                    }
                }
                return 0;
            }
            case STRING_D: 
            case STRING_S: 
            case STRING_R: {
                String value = this.lexer.getText();
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.charValue.setChar(0, value);
                        return 5;
                    }
                }
                return 0;
            }
            case NA_CHAR: {
                switch (this.lexer.next()) {
                    case EOF: {
                        if (sign != 0) break;
                        this.charValue.setNA(0);
                        return 5;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    private boolean parseFactorLevel(String expression, RCharacterStore levels) {
        if (expression.indexOf(92) >= 0) {
            if (this.formatter == null) {
                this.formatter = new RValueFormatter();
            }
            expression = this.formatter.quoteName(expression);
            this.lexer.reset((TextParserInput)new StringParserInput(expression).init());
            if (this.lexer.next() != RTerminal.STRING_D || (this.lexer.getFlags() & 0x10000) != 0) {
                return false;
            }
            expression = this.lexer.getText();
            switch (this.lexer.next()) {
                case EOF: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (levels.contains(expression) || expression != (expression = expression.trim()) && levels.contains(expression)) {
            this.charValue.setChar(0, expression);
            return true;
        }
        if (expression.equals("NA") || expression.equals("<NA>") && levels.containsNA()) {
            this.charValue.setNA(0);
            return true;
        }
        return false;
    }

    private byte parseSimpleHexInt(String expression) {
        int l = expression.length();
        if (l == 0) {
            return 0;
        }
        int i = 0;
        while (i < l) {
            switch (expression.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    break;
                }
                default: {
                    return 1;
                }
            }
            ++i;
        }
        try {
            this.intValue.setInt(0, Integer.parseInt(expression, 16));
            return 2;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean real2logi() {
        int i;
        double d;
        if (!this.numValue.isNA(0) && (d = this.numValue.getNum(0)) == (double)(i = (int)d) && i >= 0 && i <= 1) {
            this.logiValue.setInt(0, i);
            return true;
        }
        return false;
    }

    private boolean real2int() {
        int i;
        double d;
        if (!this.numValue.isNA(0) && (d = this.numValue.getNum(0)) == (double)(i = (int)d)) {
            this.intValue.setInt(0, i);
            return true;
        }
        return false;
    }

    private boolean int2raw() {
        int i;
        if (!this.intValue.isNA(0) && (i = this.intValue.getInt(0)) >= 0 && i <= 255) {
            this.rawValue.setRaw(0, (byte)i);
            return true;
        }
        return false;
    }
}

