/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataLabelProvider;
import org.eclipse.statet.internal.r.ui.datafilter.FilterListener;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.IntervalVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.LevelVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.TextVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.FilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.IntervalFilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.LevelFilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.ScrolledPageComposite;
import org.eclipse.statet.internal.r.ui.datafilterview.TextFilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class VariableContainer {
    private final IServiceLocator serviceLocator;
    private final ScrolledPageComposite composite;
    private final List<VariableComposite> variables;
    private final RDataLabelProvider labelProvider;
    private final FilterSet filterSet;
    private @Nullable RDataTableContentDescription description;

    public VariableContainer(IServiceLocator serviceLocator, ScrolledPageComposite composite) {
        this.serviceLocator = serviceLocator;
        this.composite = composite;
        this.variables = new ArrayList<VariableComposite>();
        this.composite.getContent().setLayout((Layout)LayoutUtils.newContentGrid((int)1));
        this.labelProvider = new RDataLabelProvider();
        this.filterSet = new FilterSet((Realm)ObjectUtils.nonNullAssert((Object)Realm.getDefault())){

            @Override
            protected void updateFilter(int idx, @Nullable VariableFilter oldFilter, @Nullable VariableFilter newFilter) {
                if (newFilter == null) {
                    VariableContainer.this.removeVariable(idx);
                    return;
                }
                int oldIdx = VariableContainer.this.getVariable(oldFilter);
                if (oldIdx == idx) {
                    VariableContainer.this.updateVariable(idx, newFilter);
                } else if (oldIdx > idx) {
                    VariableContainer.this.moveVariable(oldIdx, idx);
                    VariableContainer.this.updateVariable(idx, newFilter);
                } else {
                    if (!this.isInputFilterUpdate() && oldFilter != null) {
                        VariableContainer.this.removeVariable(idx);
                    }
                    VariableContainer.this.addVariable(idx, newFilter);
                }
            }

            @Override
            protected void completeInputFilterUpdate(ImList<VariableFilter> filter) {
                VariableContainer.this.removeVariables(filter.size());
            }
        };
        this.filterSet.addPostListener(new FilterListener(){

            @Override
            public void filterChanged() {
                for (VariableComposite variable : VariableContainer.this.variables) {
                    variable.updateImage(false);
                }
            }
        });
    }

    public void updateInput(RDataTableContentDescription description) {
        this.description = description;
        this.composite.setRedraw(false);
        this.composite.setDelayedReflow(true);
        try {
            this.filterSet.updateInput(description);
            if (this.variables.size() == 1) {
                this.variables.get(0).setExpanded(true);
            }
        }
        finally {
            this.composite.setDelayedReflow(false);
            this.composite.setRedraw(true);
            this.composite.reflow(true);
        }
    }

    public @Nullable RDataTableContentDescription getDescription() {
        return this.description;
    }

    private void addVariable(int idx, VariableFilter filter) {
        boolean insert = idx < this.variables.size();
        VariableComposite composite = this.createVariable(filter.getColumn());
        this.createFilterClient(composite, filter);
        if (insert) {
            composite.moveAbove((Control)this.variables.get(idx));
        }
        this.variables.add(idx, composite);
    }

    private void moveVariable(int fromIdx, int toIdx) {
        if (fromIdx <= toIdx) {
            throw new UnsupportedOperationException();
        }
        this.variables.get(fromIdx).moveAbove((Control)this.variables.get(toIdx));
        this.variables.add(toIdx, this.variables.remove(fromIdx));
    }

    private void updateVariable(int idx, VariableFilter filter) {
        VariableComposite composite = this.variables.get(idx);
        composite.setColumn(filter.getColumn());
        FilterClient<?> oldClient = composite.getClient();
        this.createFilterClient(composite, filter);
        if (oldClient != null) {
            oldClient.dispose();
        }
        composite.layout(new Control[]{composite.getClient()});
    }

    private void removeVariable(int idx) {
        if (idx >= this.variables.size()) {
            return;
        }
        VariableComposite composite = this.variables.remove(idx);
        composite.dispose();
    }

    private void removeVariables(int startIdx) {
        int size;
        while ((size = this.variables.size()) > startIdx) {
            this.removeVariable(size - 1);
        }
    }

    protected @Nullable FilterClient<?> createFilterClient(VariableComposite composite, @Nullable VariableFilter filter) {
        FilterClient client;
        if (filter == null) {
            return null;
        }
        switch (filter.getType().getId()) {
            case 0: {
                client = new LevelFilterClient(composite, (LevelVariableFilter)filter);
                break;
            }
            case 1: {
                client = new IntervalFilterClient(composite, (IntervalVariableFilter)filter);
                break;
            }
            case 2: {
                client = new TextFilterClient(composite, (TextVariableFilter)filter);
                break;
            }
            default: {
                throw new IllegalStateException(filter.toString());
            }
        }
        this.composite.adaptChild((Control)client);
        return client;
    }

    protected VariableComposite createVariable(RDataTableColumn column) {
        VariableComposite expandable = new VariableComposite(this.composite.getContent(), this, column);
        expandable.setLayoutData(new GridData(4, 4, true, false));
        this.composite.adaptChild((Control)expandable);
        return expandable;
    }

    public FilterSet getFilterSet() {
        return this.filterSet;
    }

    public IServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public ScrolledPageComposite getComposite() {
        return this.composite;
    }

    public List<VariableComposite> getVariables() {
        return this.variables;
    }

    protected int getVariable(@Nullable VariableFilter filter) {
        if (filter != null) {
            int i = 0;
            while (i < this.variables.size()) {
                FilterClient<?> client = this.variables.get(i).getClient();
                if (client != null && client.getFilter() == filter) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public RDataLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void dispose() {
        this.labelProvider.dispose();
    }
}

