/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitioner;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.REditor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateCompletionComputer;
import org.eclipse.statet.ltk.ui.templates.config.AbstractEditorTemplatesPage;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.source.RPartitionNodeType;
import org.eclipse.statet.r.ui.sourceediting.RTemplateSourceViewerConfigurator;
import org.eclipse.ui.texteditor.ITextEditor;

@NonNullByDefault
public class REditorTemplatesPage
extends AbstractEditorTemplatesPage {
    private @Nullable SourceEditorViewerConfigurator rPreviewConfigurator;

    public REditorTemplatesPage(REditor editor) {
        super(RUIPlugin.getInstance().getREditorTemplateStore(), (ITextEditor)editor, (SourceEditor)editor);
    }

    protected String getPreferencePageId() {
        return "org.eclipse.statet.r.preferencePages.REditorTemplates";
    }

    protected IPreferenceStore getTemplatePreferenceStore() {
        return RUIPlugin.getInstance().getPreferenceStore();
    }

    protected String[] getContextTypeIds(IDocument document, int offset) {
        try {
            String partitionType = TextUtilities.getContentType((IDocument)document, (String)this.getSourceEditor().getDocumentContentInfo().getPartitioning(), (int)offset, (boolean)true);
            if (partitionType == "R.Roxygen") {
                return new String[]{"roxygen"};
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new String[]{"r-code"};
    }

    protected @Nullable TemplateCompletionComputer getComputer(AssistInvocationContext context, Template template) {
        return (TemplateCompletionComputer)RUIPlugin.getInstance().getREditorContentAssistRegistry().getComputer("org.eclipse.statet.r.contentAssistComputers.RTemplateCompletion");
    }

    protected SourceEditorViewerConfigurator getTemplatePreviewConfig(Template template, TemplateVariableProcessor templateProcessor) {
        SourceEditorViewerConfigurator configurator = this.rPreviewConfigurator;
        if (configurator == null) {
            this.rPreviewConfigurator = configurator = new RTemplateSourceViewerConfigurator(RCore.WORKBENCH_ACCESS, templateProcessor);
        }
        return configurator;
    }

    protected SourceEditorViewerConfigurator getTemplateEditConfig(Template template, TemplateVariableProcessor templateProcessor) {
        return new RTemplateSourceViewerConfigurator(RCore.WORKBENCH_ACCESS, templateProcessor);
    }

    protected void configureDocument(AbstractDocument document, TemplateContextType contextType, SourceEditorViewerConfigurator configurator) {
        String partitioning = configurator.getDocumentContentInfo().getPartitioning();
        TreePartitioner partitioner = (TreePartitioner)document.getDocumentPartitioner(partitioning);
        if (contextType.getId().equals("roxygen")) {
            partitioner.setStartType((TreePartitionNodeType)RPartitionNodeType.ROXYGEN);
        } else {
            partitioner.setStartType((TreePartitionNodeType)RPartitionNodeType.DEFAULT_ROOT);
        }
        partitioner.disconnect();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(partitioning, (IDocumentPartitioner)partitioner);
    }
}

