/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs.groups;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.statet.ecommons.ui.dialogs.groups.OptionsGroup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Layouter {
    public static final int DEFAULT_INDENTION = 20;
    public Composite composite;
    public int fNumColumns;

    public Layouter(Composite composite, int numColums) {
        this.composite = composite;
        this.fNumColumns = numColums;
        GridLayout layout = new GridLayout();
        if (!(composite instanceof Group)) {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        layout.numColumns = this.fNumColumns;
        composite.setLayout((Layout)layout);
    }

    public Layouter(Composite composite, GridLayout layout) {
        this.composite = composite;
        this.fNumColumns = layout.numColumns;
        composite.setLayout((Layout)layout);
    }

    public void add(Control composite) {
        this.add(composite, this.fNumColumns);
    }

    public void add(Control composite, int horizontalSpan) {
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = horizontalSpan;
        composite.setLayoutData((Object)gd);
    }

    public void addFiller() {
        Dialog.applyDialogFont((Control)this.composite);
        PixelConverter pixelConverter = new PixelConverter((Control)this.composite);
        Label filler = new Label(this.composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = this.fNumColumns;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    public void addSpaceGrabber() {
        Label filler = new Label(this.composite, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = this.fNumColumns;
        filler.setLayoutData((Object)gd);
    }

    public Label addLabel(String text) {
        return this.addLabel(text, 0, this.fNumColumns);
    }

    public Label addLabel(String text, int indentation, int hSpan) {
        return this.addLabel(text, indentation, hSpan, false);
    }

    public Label addLabel(String text, int indentation, int hSpan, boolean vAlignTop) {
        Label label = new Label(this.composite, 16384);
        label.setText(text);
        GridData gd = new GridData(4, vAlignTop ? 128 : 0x1000000, false, false);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = hSpan;
        label.setLayoutData((Object)gd);
        return label;
    }

    public Button addCheckBox(String label) {
        return this.addCheckBox(label, 0, this.fNumColumns);
    }

    public Button addCheckBox(String label, int indentation) {
        return this.addCheckBox(label, indentation, this.fNumColumns);
    }

    public Button addCheckBox(String label, int indentation, int horizontalSpan) {
        Button checkBox = new Button(this.composite, 32);
        checkBox.setText(label);
        GridData gd = new GridData(1, 1, false, false);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = horizontalSpan;
        checkBox.setLayoutData((Object)gd);
        return checkBox;
    }

    public Text addTextControl() {
        return this.addTextControl(0, this.fNumColumns, true, -1);
    }

    public Text addTextControl(int hIndent, int horizontalSpan, boolean hGrab, int widthHint) {
        Text text = new Text(this.composite, 2052);
        GridData gd = new GridData(hGrab ? 4 : 16384, 0x1000000, hGrab, false);
        gd.horizontalIndent = hIndent;
        gd.horizontalSpan = horizontalSpan;
        if (widthHint > 0) {
            gd.widthHint = new PixelConverter((Control)text).convertWidthInCharsToPixels(widthHint);
        }
        text.setLayoutData((Object)gd);
        return text;
    }

    public Text addLabeledTextControl(String label) {
        this.addLabel(label, 0, 1);
        return this.addTextControl(0, this.fNumColumns - 1, true, -1);
    }

    public Combo addLabeledComboControl(String label, String[] items) {
        this.addLabel(label, 0, 1);
        return this.addComboControl(items, true, 0, this.fNumColumns - 1, false);
    }

    public Combo addComboControl(String[] items, int numColumns) {
        return this.addComboControl(items, true, 0, numColumns, true);
    }

    public Combo addComboControl(String[] items, boolean readOnly, int hIndent, int hSpan, boolean hGrab) {
        int style = 4;
        if (readOnly) {
            style |= 8;
        }
        Combo combo = new Combo(this.composite, style);
        if (items != null) {
            combo.setItems(items);
        }
        GridData gd = new GridData(hGrab ? 4 : 16384, 0x1000000, hGrab, false);
        gd.horizontalIndent = hIndent;
        gd.horizontalSpan = hSpan;
        gd.widthHint = LayoutUtils.hintWidth((Combo)combo, (String[])items);
        combo.setLayoutData((Object)gd);
        return combo;
    }

    public Button addButton(String label, SelectionListener listener) {
        return this.addButton(label, listener, this.fNumColumns);
    }

    public Button addButton(String label, SelectionListener listener, int horizontalSpan) {
        Button button = new Button(this.composite, 8);
        button.setText(label);
        GridData gd = new GridData(4, 1, false, false);
        gd.horizontalSpan = horizontalSpan;
        gd.minimumWidth = LayoutUtils.hintWidth((Button)button);
        button.setLayoutData((Object)gd);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public void addGroup(OptionsGroup group) {
        group.createGroup(this.composite, this.fNumColumns);
    }

    public Group addGroup(String label) {
        return this.addGroup(label, false);
    }

    public Group addGroup(String label, boolean grabVerticalSpace) {
        Group group = new Group(this.composite, 0);
        group.setText(label);
        GridData gd = new GridData(4, 4, true, grabVerticalSpace);
        gd.horizontalSpan = this.fNumColumns;
        group.setLayoutData((Object)gd);
        return group;
    }
}

