/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.ecommons.ui.actions.WorkbenchScopingHandler;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.actions.AbstractToolScopeHandler;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class TerminateToolHandler
extends AbstractToolScopeHandler<ToolProcess> {
    public TerminateToolHandler(Object scope) {
        super(scope, "org.eclipse.debug.ui.commands.Terminate");
    }

    @Override
    protected boolean isSupported(Tool tool) {
        return tool instanceof ToolProcess;
    }

    @Override
    protected boolean evaluateIsEnabled(ToolProcess tool) {
        return tool.canTerminate();
    }

    @Override
    public @Nullable Object execute(ExecutionEvent event, ToolProcess tool, IEvaluationContext evalContext) throws ExecutionException {
        try {
            tool.terminate();
            IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)false);
            IConsole console = DebugUITools.getConsole((IProcess)tool);
            if (console instanceof NIConsole) {
                NicoUITools.showConsole((NIConsole)console, page, true);
            }
        }
        catch (DebugException e) {
            int severity = e.getStatus().getSeverity();
            StatusManager.getManager().handle((IStatus)new Status(severity, "org.eclipse.statet.nico.ui", -1, Messages.TerminateToolAction_error_message, (Throwable)e), severity >= 4 ? 3 : 1);
        }
        return null;
    }

    public static class WorkbenchHandler
    extends WorkbenchScopingHandler
    implements IElementUpdater,
    IExecutableExtension {
        protected AbstractScopeHandler createScopeHandler(Object scope) {
            return new TerminateToolHandler(scope);
        }
    }
}

