/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.Match;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookSession;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.DecoratingStyledLabelProvider;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResultPage;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchLabelUtil;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultContentProvider;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultMatchTableContentProvider;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultTreeContentProvider;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpLabelProvider;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpPreferences;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpSearchResult;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpSearchUIMatch;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpView;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.statushandlers.StatusManager;

public class RHelpSearchResultPage
extends ExtTextSearchResultPage<RPkgHelp, RHelpSearchUIMatch> {
    private static final ViewerComparator ALPHA_SORTER = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            return ((RHelpSearchUIMatch)e1).compareTo((RHelpSearchUIMatch)e2);
        }
    };
    private static final ViewerComparator SCORE_SORTER = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            RHelpSearchMatch match1 = ((RHelpSearchUIMatch)e1).getRHelpMatch();
            RHelpSearchMatch match2 = ((RHelpSearchUIMatch)e2).getRHelpMatch();
            return (int)((double)(match2.getScore() - match1.getScore()) * 1.0E8);
        }
    };
    private BrowserSession reusedSession;
    private String reusedSessionUrl;
    private IWorkbenchPartReference reusedSessionView;
    private ViewerComparator currentSorter = ALPHA_SORTER;
    private SimpleContributionItem sortByName;
    private SimpleContributionItem sortByScore;

    private static Object getRelevantElement(TreePath treePath) {
        if (treePath.getSegmentCount() > 2 && treePath.getLastSegment() instanceof RHelpSearchMatch.MatchFragment) {
            return treePath.getSegment(treePath.getSegmentCount() - 2);
        }
        return treePath.getLastSegment();
    }

    public RHelpSearchResultPage() {
        super(RHelpSearchResult.COMPARATOR);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.initActions();
    }

    private void initActions() {
        this.sortByName = new SimpleContributionItem("Sort by Name", null, SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/sort.alpha"), null, 32){

            protected void execute() throws ExecutionException {
                RHelpSearchResultPage.this.currentSorter = ALPHA_SORTER;
                RHelpSearchResultPage.this.updateSorter();
            }
        };
        this.sortByScore = new SimpleContributionItem("Sort by Relevance", null, SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/sort.score"), null, 32){

            protected void execute() throws ExecutionException {
                RHelpSearchResultPage.this.currentSorter = SCORE_SORTER;
                RHelpSearchResultPage.this.updateSorter();
            }
        };
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        if (memento != null) {
            String sortValue = memento.getString("sort.by");
            this.currentSorter = sortValue != null && sortValue.equals("score") ? SCORE_SORTER : ALPHA_SORTER;
            this.updateSorter();
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        String sortValue = this.currentSorter == SCORE_SORTER ? "score" : "";
        memento.putString("sort.by", sortValue);
    }

    protected void configureTableViewer(TableViewer viewer) {
        super.configureTableViewer(viewer);
        TableColumnLayout layout = new TableColumnLayout();
        viewer.getControl().getParent().setLayout((Layout)layout);
        viewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText("Page");
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider((CellLabelProvider)new DecoratingStyledLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new RHelpLabelProvider(), TextSearchLabelUtil.DEFAULT_SEARCH_LABEL_PROPERTIES));
        column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText("Package");
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(new PixelConverter(JFaceResources.getDialogFont()).convertWidthInCharsToPixels(10), true, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                String text = "";
                if (element instanceof RHelpSearchUIMatch) {
                    RHelpSearchMatch match = ((RHelpSearchUIMatch)element).getRHelpMatch();
                    text = match.getPage().getPackage().getName();
                }
                cell.setText(text);
            }
        });
        column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText("Best Match");
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider((CellLabelProvider)new MatchLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        this.updateSorter();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        super.configureTreeViewer(viewer);
        TreeColumnLayout layout = new TreeColumnLayout();
        viewer.getControl().getParent().setLayout((Layout)layout);
        TreeViewerColumn column1 = new TreeViewerColumn(viewer, 16384);
        column1.getColumn().setText("Package / Page / Match");
        layout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column1.setLabelProvider((CellLabelProvider)new RHelpLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
    }

    protected TextSearchResultTreeContentProvider<RPkgHelp, RHelpSearchUIMatch> createTreeContentProvider(TreeViewer viewer) {
        return new TreeContentProvider(this, viewer);
    }

    protected TextSearchResultContentProvider<RPkgHelp, RHelpSearchUIMatch, TableViewer> createTableContentProvider(TableViewer viewer) {
        return new TextSearchResultMatchTableContentProvider((ExtTextSearchResultPage)this, viewer);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() == 1) {
            this.updateSorter();
            tbm.appendToGroup("group.viewerSetup", (IContributionItem)new Separator(".sorting"));
            tbm.appendToGroup(".sorting", (IContributionItem)this.sortByName);
            tbm.appendToGroup(".sorting", (IContributionItem)this.sortByScore);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.appendToGroup("group.open", (IContributionItem)new OpenHandler());
        super.fillContextMenu(mgr);
    }

    private void updateSorter() {
        StructuredViewer viewer;
        ViewerComparator sorter = this.currentSorter;
        this.sortByName.setChecked(sorter == ALPHA_SORTER);
        this.sortByScore.setChecked(sorter == SCORE_SORTER);
        if (this.getLayout() == 1 && UIAccess.isOkToUse((Viewer)(viewer = this.getViewer()))) {
            viewer.setComparator(sorter);
        }
    }

    public RHelpSearchResult getInput() {
        return (RHelpSearchResult)super.getInput();
    }

    protected void handleOpen(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            Object element = null;
            if (selection instanceof ITreeSelection) {
                element = RHelpSearchResultPage.getRelevantElement(((ITreeSelection)selection).getPaths()[0]);
            }
            if (element == null) {
                element = selection.getFirstElement();
            }
            this.open(element, true, false);
        }
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        this.openPage((RHelpSearchUIMatch)match, activate, false);
    }

    protected void open(Object element, boolean activate, boolean newPage) {
        try {
            if (element instanceof RHelpSearchUIMatch) {
                this.openPage((RHelpSearchUIMatch)element, activate, newPage);
            }
            if (element instanceof RPkgHelp) {
                this.openPackage((RPkgHelp)element, activate, newPage);
            }
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, "An error occurred when trying to open the R help page (element= " + element + ").", (Throwable)e));
        }
    }

    protected void openPage(RHelpSearchUIMatch match, boolean activate, boolean newPage) throws PartInitException {
        RHelpSearchMatch rMatch = match.getRHelpMatch();
        URI url = RCore.getRHelpHttpService().getPageHttpUrl(rMatch.getPage(), "browse");
        RHelpSearchQuery rHelpQuery = this.getInput().getQuery().getRHelpQuery();
        if (rHelpQuery.getSearchType() == 3 && rHelpQuery.getSearchString().length() > 0) {
            try {
                url = new URI(String.valueOf(url.toString()) + "?qs=" + UrlEncoded.encodeString((String)rHelpQuery.getSearchString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.doOpen(url, activate, newPage);
    }

    protected void openPackage(RPkgHelp packageHelp, boolean activate, boolean newPage) throws PartInitException {
        URI url = RCore.getRHelpHttpService().getPackageHttpUrl(packageHelp, "browse");
        this.doOpen(url, activate, newPage);
    }

    private void doOpen(URI url, boolean activate, boolean newPage) throws PartInitException {
        RHelpView view = null;
        IWorkbenchPartReference reference = this.getSite().getPage().getReference(view);
        if (!newPage && this.reusedSession != null && !this.reusedSession.getUrl().equals(this.reusedSessionUrl)) {
            this.reusedSession = null;
        } else if (this.reusedSession != null && this.reusedSessionView != null) {
            view = (RHelpView)this.reusedSessionView.getPart(false);
        }
        if (view != null) {
            if (activate) {
                view.getSite().getPage().activate((IWorkbenchPart)view);
            } else {
                view.getSite().getPage().bringToTop((IWorkbenchPart)view);
            }
        } else {
            view = (RHelpView)this.getSite().getPage().showView("org.eclipse.statet.r.views.RHelp", null, activate ? 1 : 2);
        }
        String urlString = url.toASCIIString();
        if (this.showOpenPage(view, urlString)) {
            return;
        }
        if (!newPage && ((Boolean)EPreferences.getInstancePrefs().getPreferenceValue(RHelpPreferences.SEARCH_REUSE_PAGE_ENABLED_PREF)).booleanValue()) {
            if (this.reusedSession != null && !view.canOpen(this.reusedSession)) {
                this.reusedSession = null;
            }
            this.reusedSession = view.openUrl(urlString, this.reusedSession);
        } else {
            this.reusedSession = view.openUrl(urlString, null);
        }
        this.reusedSessionUrl = urlString;
        this.reusedSessionView = reference;
    }

    private boolean showOpenPage(RHelpView view, String url) {
        BrowserSession session = BrowserSession.findSessionByUrl((ImCollection)view.getSessions(), (String)url);
        if (session != null) {
            view.showPage((PageBookSession)session);
            return true;
        }
        return false;
    }

    private static class MatchLabelProvider
    extends StyledCellLabelProvider {
        public void update(ViewerCell cell) {
            RHelpSearchMatch match;
            RHelpSearchMatch.MatchFragment[] fragments;
            Object element = cell.getElement();
            StyledString text = new StyledString();
            if (element instanceof RHelpSearchUIMatch && (fragments = (match = ((RHelpSearchUIMatch)element).getRHelpMatch()).getBestFragments()) != null && fragments.length > 0) {
                String fieldLabel = fragments[0].getFieldLabel();
                if (fieldLabel != null) {
                    text.append(fieldLabel, StyledString.QUALIFIER_STYLER);
                    text.append(": ", StyledString.QUALIFIER_STYLER);
                }
                if (fragments[0].getField() == "alias.txt") {
                    RHelpLabelProvider.append(text, fragments[0]);
                    int i = 1;
                    while (i < fragments.length) {
                        if (fragments[i].getField() == "alias.txt") {
                            text.append(", ");
                            RHelpLabelProvider.append(text, fragments[i]);
                        }
                        ++i;
                    }
                } else {
                    RHelpLabelProvider.append(text, fragments[0]);
                }
            }
            cell.setText(text.getString());
            cell.setStyleRanges(text.getStyleRanges());
            super.update(cell);
        }

        protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
            if (!applyColors && styleRange.background != null) {
                styleRange = super.prepareStyleRange(styleRange, applyColors);
                styleRange.borderStyle = 4;
                return styleRange;
            }
            return super.prepareStyleRange(styleRange, applyColors);
        }
    }

    private class OpenHandler
    extends SimpleContributionItem {
        public OpenHandler() {
            super("Open (New Page)", "O");
        }

        protected void execute() throws ExecutionException {
            block4: {
                StructuredViewer viewer = RHelpSearchResultPage.this.getViewer();
                if (!UIAccess.isOkToUse((Viewer)viewer)) break block4;
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (selection instanceof ITreeSelection) {
                    TreePath[] paths = ((ITreeSelection)selection).getPaths();
                    int i = 0;
                    while (i < paths.length) {
                        RHelpSearchResultPage.this.open(RHelpSearchResultPage.getRelevantElement(paths[i]), true, true);
                        ++i;
                    }
                } else {
                    Iterator iter = selection.iterator();
                    while (iter.hasNext()) {
                        RHelpSearchResultPage.this.open(iter.next(), true, true);
                    }
                }
            }
        }
    }

    private static class TreeContentProvider
    extends TextSearchResultTreeContentProvider<RPkgHelp, RHelpSearchUIMatch> {
        public TreeContentProvider(RHelpSearchResultPage page, TreeViewer viewer) {
            super((ExtTextSearchResultPage)page, viewer);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof RPkgHelp) {
                return true;
            }
            if (element instanceof RHelpSearchUIMatch) {
                RHelpSearchMatch.MatchFragment[] fragments = ((RHelpSearchUIMatch)element).getRHelpMatch().getBestFragments();
                return fragments != null && fragments.length > 0;
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RPkgHelp) {
                return super.getChildren(parentElement);
            }
            if (parentElement instanceof RHelpSearchUIMatch) {
                return ((RHelpSearchUIMatch)parentElement).getRHelpMatch().getBestFragments();
            }
            return NO_ELEMENTS;
        }
    }
}

