/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.sourceediting;

import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCodeStyleSettings;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikidocDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikidocSourceViewerConfiguration;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;

@NonNullByDefault
public class WikidocSourceViewerConfigurator
extends SourceEditorViewerConfigurator
implements WikitextCoreAccess,
PropertyChangeListener {
    private static final Set<String> RESET_GROUP_IDS = ImCollections.newSet((Object)"Wikitext/Wikitext.codestyle/indent");
    private final WikitextMarkupLanguage markupLanguage;
    private WikitextCoreAccess sourceCoreAccess = (WikitextCoreAccess)ObjectUtils.nonNullLateInit();
    private final WikitextCodeStyleSettings wikitextCodeStyleCopy;

    public WikidocSourceViewerConfigurator(WikitextMarkupLanguage markupLanguage, @Nullable WikitextCoreAccess coreAccess, WikidocSourceViewerConfiguration config) {
        super((SourceEditorViewerConfiguration)config);
        this.markupLanguage = (WikitextMarkupLanguage)ObjectUtils.nonNullAssert((Object)markupLanguage);
        this.wikitextCodeStyleCopy = new WikitextCodeStyleSettings(1);
        config.setCoreAccess(this);
        this.setSource(coreAccess);
        this.wikitextCodeStyleCopy.load(this.sourceCoreAccess.getWikitextCodeStyle());
        this.wikitextCodeStyleCopy.resetDirty();
        this.wikitextCodeStyleCopy.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new WikidocDocumentSetupParticipant(this.markupLanguage);
    }

    protected Set<String> getResetGroupIds() {
        return RESET_GROUP_IDS;
    }

    public void setSource(@Nullable WikitextCoreAccess newAccess) {
        if (newAccess == null) {
            newAccess = WikitextCore.getWorkbenchAccess();
        }
        if (this.sourceCoreAccess != newAccess) {
            this.sourceCoreAccess = newAccess;
            this.handleSettingsChanged(null, null);
        }
    }

    public void setTarget(SourceEditor sourceEditor) {
        super.setTarget(sourceEditor);
        SourceViewer viewer = sourceEditor.getViewer();
        viewer.getTextWidget().setData(ISourceViewer.class.getName(), (Object)viewer);
        viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)this.markupLanguage);
    }

    public void handleSettingsChanged(@Nullable Set<String> groupIds, @Nullable Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        this.wikitextCodeStyleCopy.resetDirty();
    }

    protected void checkSettingsChanges(Set<String> groupIds, Map<String, Object> options) {
        super.checkSettingsChanges(groupIds, options);
        if (groupIds.contains("Wikitext/Wikitext.codestyle/indent")) {
            this.wikitextCodeStyleCopy.load(this.sourceCoreAccess.getWikitextCodeStyle());
        }
        if (groupIds.contains("org.eclipse.statet.docmlet.wikitext.ui/editor/editing")) {
            this.updateCompleteConfig = true;
        }
    }

    public PreferenceAccess getPrefs() {
        return this.sourceCoreAccess.getPrefs();
    }

    public WikitextCodeStyleSettings getWikitextCodeStyle() {
        return this.wikitextCodeStyleCopy;
    }
}

