/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autorun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationComparator;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTreeContentProvider;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.internal.eutils.autorun.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.prefs.BackingStoreException;

public class AutoRunPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ILaunchManager launchManager;
    private Button enableButton;
    private TreeViewer entryViewer;
    private Button viewButton;
    private Label modeLabel;
    private ComboViewer modeViewer;
    private Set<String> lastMode;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        Composite composite = new Composite(parent, 0);
        GridLayout gd = new GridLayout();
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        gd.numColumns = 3;
        composite.setLayout((Layout)gd);
        this.enableButton = new Button(composite, 32);
        this.enableButton.setText("Enable &launch at startup of:");
        this.enableButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.entryViewer = new TreeViewer(composite, 67584);
        Tree tree = this.entryViewer.getTree();
        GridData gd2 = new GridData(4, 4, true, true, 2, 1);
        Dialog.applyDialogFont((Control)this.entryViewer.getControl());
        gd2.heightHint = tree.getItemHeight() * 10;
        this.entryViewer.getControl().setLayoutData((Object)gd2);
        this.entryViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.entryViewer.setContentProvider((IContentProvider)new LaunchConfigurationTreeContentProvider("run", this.getShell()){

            public Object[] getElements(Object parentElement) {
                Object[] children = super.getChildren(parentElement);
                ArrayList<Object> filtered = new ArrayList<Object>(children.length);
                int i = 0;
                while (i < children.length) {
                    if (super.hasChildren(children[i])) {
                        filtered.add(children[i]);
                    }
                    ++i;
                }
                return filtered.toArray();
            }
        });
        this.entryViewer.setComparator((ViewerComparator)new LaunchConfigurationComparator());
        this.viewButton = new Button(composite, 8);
        this.viewButton.setText("View/&Edit...");
        gd = new GridData(4, 128, false, false, 1, 1);
        Dialog.applyDialogFont((Control)this.viewButton);
        gd.widthHint = Math.max(this.viewButton.computeSize((int)-1, (int)-1).x, this.convertHorizontalDLUsToPixels(61));
        this.viewButton.setLayoutData((Object)gd);
        this.viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object element = ((IStructuredSelection)AutoRunPreferencePage.this.entryViewer.getSelection()).getFirstElement();
                if (element instanceof ILaunchConfiguration) {
                    DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)AutoRunPreferencePage.this.getShell(), (ILaunchConfiguration)((ILaunchConfiguration)element), (String)"org.eclipse.debug.ui.launchGroup.run");
                }
            }
        });
        this.modeLabel = new Label(composite, 0);
        this.modeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.modeLabel.setText("Launch &Mode:");
        this.modeViewer = new ComboViewer(composite, 12);
        this.modeViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.modeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final StringBuilder fStringBuilder = new StringBuilder();

            public String getText(Object element) {
                this.fStringBuilder.setLength(0);
                Iterator iter = ((Set)element).iterator();
                if (iter.hasNext()) {
                    this.append(AutoRunPreferencePage.this.launchManager.getLaunchMode((String)iter.next()));
                    while (iter.hasNext()) {
                        this.fStringBuilder.append("+");
                        this.append(AutoRunPreferencePage.this.launchManager.getLaunchMode((String)iter.next()));
                    }
                }
                return this.fStringBuilder.toString();
            }

            private void append(ILaunchMode mode) {
                String s = mode.getLabel();
                int i = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (c == '&') {
                        if (++i < s.length()) {
                            this.fStringBuilder.append(s.charAt(i));
                        }
                    } else {
                        this.fStringBuilder.append(c);
                    }
                    ++i;
                }
            }
        });
        this.entryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AutoRunPreferencePage.this.updateModes();
            }
        });
        this.modeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element != null) {
                    AutoRunPreferencePage.this.lastMode = (Set)element;
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.loadConfigs();
        this.loadPrefs();
        return composite;
    }

    private void updateModes() {
        Object element = ((IStructuredSelection)this.entryViewer.getSelection()).getFirstElement();
        if (element instanceof ILaunchConfiguration) {
            try {
                Set combinations = ((ILaunchConfiguration)element).getType().getSupportedModeCombinations();
                Iterator iter = combinations.iterator();
                while (iter.hasNext()) {
                    if (((Set)iter.next()).size() == 1) continue;
                    iter.remove();
                }
                Set[] array = combinations.toArray(new Set[combinations.size()]);
                if (array.length > 0) {
                    this.modeViewer.setInput((Object)array);
                    if (this.lastMode != null && combinations.contains(this.lastMode)) {
                        this.modeViewer.setSelection((ISelection)new StructuredSelection(this.lastMode));
                    } else {
                        this.modeViewer.setSelection((ISelection)new StructuredSelection((Object)array[0]));
                    }
                    this.modeLabel.setEnabled(true);
                    this.modeViewer.getControl().setEnabled(true);
                    return;
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.eutils.autorun", -1, "An error occured when loading supported modes for the launch configuration.", (Throwable)e));
            }
        }
        this.modeViewer.setInput((Object)new Set[0]);
        this.modeLabel.setEnabled(false);
        this.modeViewer.getControl().setEnabled(false);
    }

    private void loadConfigs() {
        try {
            ILaunchConfiguration[] launchConfigurations = this.launchManager.getLaunchConfigurations();
            this.entryViewer.setInput((Object)launchConfigurations);
        }
        catch (CoreException e) {
            Activator.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.statet.eutils.autorun", -1, "Error occured when loading available launch configurations.", (Throwable)e));
            this.enableButton.setSelection(false);
            this.enableButton.setEnabled(false);
            this.updateModes();
            return;
        }
    }

    private void loadPrefs() {
        IPreferencesService preferences = Platform.getPreferencesService();
        this.enableButton.setSelection(preferences.getBoolean("org.eclipse.statet.eutils.autorun", "enabled", true, null));
        try {
            String key = preferences.getString("org.eclipse.statet.eutils.autorun", "config.id", null, null);
            ILaunchConfiguration config = key != null && key.length() > 0 ? this.launchManager.getLaunchConfiguration(key) : null;
            this.entryViewer.setSelection((ISelection)(config != null ? new StructuredSelection((Object)config) : new StructuredSelection()));
        }
        catch (CoreException key) {
            // empty catch block
        }
        String mode = preferences.getString("org.eclipse.statet.eutils.autorun", "mode.id", null, null);
        if (mode != null) {
            this.lastMode = new HashSet<String>(1);
            this.lastMode.add(mode);
        }
        this.updateModes();
    }

    private void savePrefs(boolean flush) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.statet.eutils.autorun");
        node.putBoolean("enabled", this.enableButton.getSelection());
        Object element = ((IStructuredSelection)this.entryViewer.getSelection()).getFirstElement();
        String key = null;
        if (element instanceof ILaunchConfiguration) {
            try {
                key = ((ILaunchConfiguration)element).getMemento();
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.eutils.autorun", -1, "An error occured when saving the autorun launch configuration.", (Throwable)e));
                return;
            }
        }
        if (key != null) {
            node.put("config.id", key);
            Set modes = (Set)((IStructuredSelection)this.modeViewer.getSelection()).getFirstElement();
            if (modes != null && modes.size() == 1) {
                node.put("mode.id", (String)modes.iterator().next());
            }
        } else {
            node.remove("config.id");
        }
        if (flush) {
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.eutils.autorun", -1, "An error occured when saving the autorun launch configuration.", (Throwable)e));
            }
        }
    }

    protected void performDefaults() {
        this.enableButton.setSelection(true);
        this.entryViewer.setSelection((ISelection)new StructuredSelection());
    }

    protected void performApply() {
        this.savePrefs(true);
    }

    public boolean performOk() {
        this.savePrefs(false);
        return true;
    }
}

