/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.ts.core;

import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public interface ToolCommandData {
    public @Nullable Object getRawData(String var1);

    public <TData> @Nullable TData get(String var1, Class<TData> var2) throws IllegalDataException;

    default public <TData> TData get(String key, Class<TData> type, @NonNull TData defaultData) throws IllegalDataException {
        TData data = this.get(key, type);
        if (data == null) {
            return defaultData;
        }
        return data;
    }

    default public <TData> TData getRequired(String key, Class<TData> type) throws IllegalDataException {
        TData data = this.get(key, type);
        if (data == null) {
            throw new IllegalDataException(String.format("Data entry '%1$s' is missing.", key));
        }
        return data;
    }

    default public @Nullable String getString(String key) throws IllegalDataException {
        return this.get(key, String.class);
    }

    default public String getString(String key, String defaultData) throws IllegalDataException {
        return this.get(key, String.class, defaultData);
    }

    default public String getStringRequired(String key) throws IllegalDataException {
        return this.getRequired(key, String.class);
    }

    default public boolean getBoolean(String key, boolean defaultData) throws IllegalDataException {
        return this.get(key, Boolean.class, defaultData);
    }

    default public boolean getBooleanRequired(String key) throws IllegalDataException {
        return this.getRequired(key, Boolean.class);
    }

    default public int getInt(String key, int defaultData) throws IllegalDataException {
        return this.get(key, Integer.class, defaultData);
    }

    default public int getIntRequired(String key) throws IllegalDataException {
        return this.getRequired(key, Integer.class);
    }

    public void setReturnData(String var1, @Nullable Object var2);

    public void removeReturnData(String var1);

    public static class IllegalDataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IllegalDataException(String message) {
            super(message);
        }
    }
}

