/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.internal.r.core.rmodel.RModelIndex;

public class RModelDeleteParticipant
extends DeleteParticipant {
    private IProject project;

    public String getName() {
        return Messages.RModel_DeleteParticipant_name;
    }

    protected boolean initialize(Object element) {
        if (element instanceof IProject) {
            try {
                if (((IProject)element).hasNature("org.eclipse.statet.r.resourceProjects.R")) {
                    this.project = (IProject)element;
                    return true;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.project != null) {
            return new DeleteProjectChange(this.project);
        }
        return null;
    }

    private class DeleteProjectChange
    extends Change {
        private final IProject project;

        public DeleteProjectChange(IProject project) {
            this.project = project;
        }

        public String getName() {
            return NLS.bind((String)Messages.RModel_DeleteProject_name, (Object)this.project.getName());
        }

        public Object getModifiedElement() {
            return this.project;
        }

        public void initializeValidationData(IProgressMonitor monitor) {
        }

        public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            RefactoringStatus status = new RefactoringStatus();
            return status;
        }

        public Change perform(IProgressMonitor monitor) throws CoreException {
            RModelIndex index = RCorePlugin.getInstance().getRModelManager().getIndex();
            if (index != null) {
                index.updateProjectConfigRemoved(this.project);
            }
            return null;
        }

        public String toString() {
            return this.getName();
        }
    }
}

