/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.internal.r.debug.core.model.RStackFrameImpl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class REvalExpressionTask {
    private final String rExpression;
    private final RStackFrameImpl frame;
    private final Key key;

    public REvalExpressionTask(String expressionText, RStackFrameImpl frame) {
        this.rExpression = expressionText;
        this.frame = frame;
        this.key = new Key(frame.getDbgFrame().getHandle(), expressionText);
    }

    public String getRExpression() {
        return this.rExpression;
    }

    public RStackFrameImpl getStackFrame() {
        return this.frame;
    }

    public RMainThread getThread() {
        return this.frame.getThread();
    }

    public Key getKey() {
        return this.key;
    }

    public static class Key {
        private final Long handle;
        private final String expression;

        public Key(Long handle, String expression) {
            this.handle = handle;
            this.expression = expression;
        }

        public int hashCode() {
            return this.handle.hashCode() + this.expression.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.handle.equals(other.handle) && this.expression.equals(other.expression);
            }
            return false;
        }
    }
}

