/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.statet.internal.r.ui.correction.ConvertFCallToPipeForwardAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RLinkedNamesAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RenameInRegionAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RenameInWorkspaceAssistProposal;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistComputer;
import org.eclipse.statet.r.core.refactoring.FCallToPipeForwardRefactoring;
import org.eclipse.statet.r.core.rmodel.RCompositeSourceElement;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.core.rmodel.RLangSourceElement;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.source.RSourceConstants;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;

@NonNullByDefault
public class RQuickRefactoringComputer
implements QuickAssistComputer {
    public void computeAssistProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context instanceof RAssistInvocationContext) {
            this.computeAssistProposals((RAssistInvocationContext)context, proposals, monitor);
        }
    }

    public void computeAssistProposals(RAssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        RAstNode node;
        block8: {
            node = context.getSelectionRAstNode();
            if (node == null) {
                return;
            }
            if (node.getNodeType() == NodeType.SYMBOL || node.getNodeType() == NodeType.STRING_CONST) {
                RAstNode candidate = node;
                while (candidate != null) {
                    ImList attachments = candidate.getAttachments();
                    block1: for (Object attachment : attachments) {
                        if (!(attachment instanceof RElementAccess)) continue;
                        RElementAccess access = (RElementAccess)attachment;
                        while (access != null) {
                            if (access.getSegmentName() == null) continue block1;
                            if (access.getNameNode() == node) {
                                this.addAccessAssistProposals(context, access, proposals);
                                break block8;
                            }
                            access = access.getNextSegment();
                        }
                    }
                    candidate = candidate.getRParent();
                }
            } else if (context.getLength() > 0 && context.getSourceUnit() != null) {
                proposals.add((AssistProposal)new RenameInRegionAssistProposal(context));
            }
        }
        this.addFCallProposals(context, node, proposals);
        this.addFCallArgProposals(context, node, proposals);
    }

    protected void addAccessAssistProposals(RAssistInvocationContext context, RElementAccess access, AssistProposalCollector proposals) {
        RAstNode accessNameNode = access.getNameNode();
        if (accessNameNode == null) {
            return;
        }
        ImIdentityList allAccess = ImCollections.toIdentityList((Collection)access.getAllInUnit(false));
        int current = allAccess.indexOf((Object)access);
        if (current < 0) {
            return;
        }
        proposals.add((AssistProposal)new RLinkedNamesAssistProposal(1, context, access));
        if (allAccess.size() > 1) {
            proposals.add((AssistProposal)new RLinkedNamesAssistProposal(2, context, access));
            proposals.add((AssistProposal)new RLinkedNamesAssistProposal(3, context, access));
            TextRegion rChunk = this.getRChunk(context, accessNameNode);
            if (rChunk != null) {
                int chunkBegin = 0;
                int offset = rChunk.getStartOffset();
                while (chunkBegin < current) {
                    RAstNode nameNode = ((RElementAccess)allAccess.get(chunkBegin)).getNameNode();
                    if (nameNode != null && offset <= nameNode.getStartOffset()) break;
                    ++chunkBegin;
                }
                int chunkEnd = current + 1;
                int offset2 = rChunk.getEndOffset();
                while (chunkEnd < allAccess.size()) {
                    RAstNode nameNode = ((RElementAccess)allAccess.get(chunkEnd)).getNameNode();
                    if (nameNode != null && offset2 <= nameNode.getStartOffset()) break;
                    ++chunkEnd;
                }
                if (chunkEnd - chunkBegin > 1) {
                    proposals.add((AssistProposal)new RLinkedNamesAssistProposal(4, context, access, rChunk));
                }
            }
        }
        if (context.getSourceUnit() instanceof RWorkspaceSourceUnit) {
            proposals.add((AssistProposal)new RenameInWorkspaceAssistProposal(context, accessNameNode));
        }
    }

    protected @Nullable TextRegion getRChunk(RAssistInvocationContext context, RAstNode accessNameNode) {
        List elements;
        RLangSourceElement element;
        SourceStructElement sourceElement;
        SourceUnitModelInfo modelInfo = context.getModelInfo();
        if (modelInfo != null && (sourceElement = modelInfo.getSourceElement()) instanceof RCompositeSourceElement && (element = (RLangSourceElement)LtkModelUtils.getCoveringSourceElement((List)(elements = ((RCompositeSourceElement)sourceElement).getCompositeElements()), (int)accessNameNode.getStartOffset())) != null) {
            return element.getSourceRange();
        }
        return null;
    }

    protected void addFCallProposals(RAssistInvocationContext context, RAstNode node, AssistProposalCollector proposals) {
        FCallToPipeForwardRefactoring refactoring;
        RefactoringStatus status;
        RSourceUnit sourceUnit = context.getSourceUnit();
        FCall fCall = this.findFCall(node);
        if (sourceUnit == null || fCall == null) {
            return;
        }
        FCall.Args args = fCall.getArgsChild();
        if (context.getRCoreAccess().getRSourceConfig().getLangVersion().compareTo(RSourceConstants.LANG_VERSION_4_1) >= 0 && args.getChildCount() > 0 && !(status = (refactoring = new FCallToPipeForwardRefactoring(sourceUnit, fCall)).checkInitialConditions(null)).hasFatalError()) {
            proposals.add((AssistProposal)new ConvertFCallToPipeForwardAssistProposal(context, refactoring));
        }
    }

    protected void addFCallArgProposals(RAssistInvocationContext context, RAstNode node, AssistProposalCollector proposals) {
        FCallToPipeForwardRefactoring refactoring;
        RefactoringStatus status;
        RSourceUnit sourceUnit = context.getSourceUnit();
        FCall.Arg arg = this.findFCallArg(node, (TextRegion)context);
        if (sourceUnit == null || arg == null) {
            return;
        }
        FCall fCall = arg.getRParent().getRParent();
        if (context.getRCoreAccess().getRSourceConfig().getLangVersion().compareTo(RSourceConstants.LANG_VERSION_4_2) >= 0 && arg.hasName() && !(status = (refactoring = new FCallToPipeForwardRefactoring(sourceUnit, fCall, arg)).checkInitialConditions(null)).hasFatalError()) {
            proposals.add((AssistProposal)new ConvertFCallToPipeForwardAssistProposal(context, refactoring));
        }
    }

    private @Nullable FCall findFCall(@Nullable RAstNode node) {
        block4: while (true) {
            if (node == null) {
                return null;
            }
            switch (node.getNodeType()) {
                case F_CALL: {
                    return (FCall)node;
                }
                default: {
                    node = node.getRParent();
                    continue block4;
                }
                case SOURCELINES: 
                case COMMENT: 
                case ERROR: 
                case ERROR_TERM: 
                case DUMMY: 
                case BLOCK: 
                case PIPE_FORWARD: 
                case F_CALL_ARGS: 
                case F_CALL_ARG: 
            }
            break;
        }
        return null;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FCall.Arg findFCallArg(@Nullable RAstNode node, TextRegion region) {
        block5: while (true) {
            if (node == null) {
                return null;
            }
            switch (node.getNodeType()) {
                case F_CALL_ARG: {
                    return (FCall.Arg)node;
                }
                case SYMBOL: 
                case STRING_CONST: {
                    node = node.getRParent();
                    continue block5;
                }
                default: {
                    if (node.getStartOffset() != region.getStartOffset() && node.getEndOffset() != region.getEndOffset()) break block5;
                    node = node.getRParent();
                    continue block5;
                }
                case SOURCELINES: 
                case COMMENT: 
                case ERROR: 
                case ERROR_TERM: 
                case DUMMY: 
                case BLOCK: 
                case PIPE_FORWARD: 
                case F_CALL: 
                case F_CALL_ARGS: 
            }
            break;
        }
        return null;
    }
}

