/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui;

import java.nio.file.Path;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RPkg;

public class REnvLabelProvider
extends StyledCellLabelProvider {
    public static String getSafeLabel(RLibLocation location) {
        Path store;
        String label = location.getLabel();
        if (label == null && (store = location.getDirectoryPath()) != null) {
            label = store.toString();
        }
        if (label == null) {
            label = location.getDirectory();
        }
        return label;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof REnv) {
            this.update(cell, (REnv)element);
        } else if (element instanceof REnvConfiguration) {
            this.update(cell, ((REnvConfiguration)element).getREnv());
        } else if (element instanceof RLibGroup) {
            this.update(cell, (RLibGroup)element);
        } else if (element instanceof RLibLocation) {
            this.update(cell, (RLibLocation)element);
        } else if (element instanceof RPkg) {
            this.update(cell, (RPkg)element);
        }
        this.finishUpdate(cell);
    }

    protected void finishUpdate(ViewerCell cell) {
        super.update(cell);
    }

    protected void update(ViewerCell cell, REnv rEnv) {
        cell.setImage(RUI.getImage("org.eclipse.statet.r.ui/images/obj/r_environment"));
        cell.setText(rEnv.getName());
    }

    protected void update(ViewerCell cell, REnvConfiguration rEnvConfig) {
        cell.setImage(RUI.getImage(rEnvConfig.isRemote() ? "org.eclipse.statet.r.ui/images/obj/r_environment.remote" : "org.eclipse.statet.r.ui/images/obj/r_environment"));
        cell.setText(rEnvConfig.getName());
    }

    protected void update(ViewerCell cell, RLibGroup libGroup) {
        cell.setImage(RUI.getImage("org.eclipse.statet.r.ui/images/obj/library.group"));
        cell.setText(libGroup.getLabel());
    }

    protected void update(ViewerCell cell, RLibLocation libLocation) {
        cell.setImage(RUI.getImage("org.eclipse.statet.r.ui/images/obj/library.location"));
        cell.setText(REnvLabelProvider.getSafeLabel(libLocation));
    }

    protected void update(ViewerCell cell, RPkg pkg) {
        cell.setImage(null);
        cell.setText(pkg.getName());
    }
}

