/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.util;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.statet.ecommons.models.core.util.ElementPartition;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.util.ViewActionUtil;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.ui.util.RElementInputUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

@NonNullByDefault
public class CopyRElementNameHandler
extends AbstractHandler {
    private final ViewActionUtil actionUtil;

    public CopyRElementNameHandler(ViewActionUtil actionUtil) {
        this.actionUtil = actionUtil;
    }

    private ITreeSelection getSelection() {
        ISelectionProvider selectionProvider = this.actionUtil.getSelectionProvider();
        return (ITreeSelection)selectionProvider.getSelection();
    }

    protected boolean isValidSelection(ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        for (Object element : selection.toList()) {
            if (!(element instanceof ElementPartition)) continue;
            return false;
        }
        return true;
    }

    protected @Nullable RElementName getRElementName(TreePath treePath, ITreeSelection selection) {
        return RElementInputUtils.getRElementName(treePath, selection);
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        this.setBaseEnabled(this.isValidSelection(this.getSelection()));
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        if (!UIAccess.isOkToUse((Control)this.actionUtil.getControl())) {
            return null;
        }
        ITreeSelection selection = this.getSelection();
        if (!this.isValidSelection(selection)) {
            return null;
        }
        String text = this.createData(selection);
        if (text != null) {
            this.copy(text);
        }
        return null;
    }

    protected @Nullable String createData(ITreeSelection selection) {
        TreePath[] treePaths = selection.getPaths();
        ArrayList<String> names = new ArrayList<String>(selection.size());
        int i = 0;
        while (i < treePaths.length) {
            String name;
            RElementName elementName = this.getRElementName(treePaths[i], selection);
            String string = name = elementName != null ? elementName.getDisplayName() : null;
            if (name == null) {
                this.actionUtil.getStatusLine().setMessage((IStatus)new StatusInfo(2, "Could not copy element name for the selected objects."));
                return null;
            }
            names.add(name);
            ++i;
        }
        return names.size() == 1 ? (String)names.get(0) : CollectionUtils.toString(names, (String)", ");
    }

    private void copy(String text) {
        DNDUtils.setContent((Clipboard)this.actionUtil.getClipboard(), (Object[])new String[]{text}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
    }
}

