/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.statet.internal.rhelp.core.http.BasicMediaType;
import org.eclipse.statet.jcommons.collections.BasicImMapEntry;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImMapEntry;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class HttpHeaderUtils {
    public static final String LOCATION_NAME = "Location";
    public static final String ACCEPT_NAME = "Accept";
    public static final String CACHE_CONTROL_NAME = "Cache-Control";
    public static final String QUALITY_FACTOR_PARAM_NAME = "q";

    public static List<MediaTypeEntry> readAcceptHeaderEntries(HttpServletRequest req, @Nullable BiPredicate<String, String> filter) throws ServletException {
        try {
            ArrayList<MediaTypeEntry> entries = new ArrayList<MediaTypeEntry>();
            Enumeration headers = req.getHeaders(ACCEPT_NAME);
            if (headers != null) {
                HttpHeaderUtils.parseMediaTypes(headers, filter, entries);
            }
            entries.sort(null);
            return entries;
        }
        catch (ParseException e) {
            throw new ServletException("Failed to read Accept header of request.", (Throwable)e);
        }
    }

    public static List<MediaTypeEntry> readMediaTypeEntries(Collection<String> headers, @Nullable BiPredicate<String, String> filter) throws ParseException {
        ArrayList<MediaTypeEntry> entries = new ArrayList<MediaTypeEntry>();
        if (!headers.isEmpty()) {
            HttpHeaderUtils.parseMediaTypes(Collections.enumeration(headers), filter, entries);
        }
        entries.sort(null);
        return entries;
    }

    protected static final void parseMediaTypes(Enumeration<String> headers, @Nullable BiPredicate<String, String> filter, List<MediaTypeEntry> entries) throws ParseException {
        ArrayList<BasicImMapEntry> extParams = new ArrayList<BasicImMapEntry>();
        while (headers.hasMoreElements()) {
            Tokenizer tokenizer = new Tokenizer(headers.nextElement());
            while (tokenizer.readNextEntry()) {
                extParams.clear();
                String type = tokenizer.readTokenAssert();
                tokenizer.readOperatorAssert('/');
                String subtype = tokenizer.readTokenAssert();
                boolean include = filter == null || filter.test(type, subtype);
                float qValue = 1.0f;
                int nParam = 0;
                while (tokenizer.readNextParam()) {
                    String paramName = tokenizer.readTokenAssert();
                    tokenizer.readOperatorAssert('=');
                    if (!include) {
                        tokenizer.skipParamValue();
                    } else if (nParam == 0 && paramName.equals(QUALITY_FACTOR_PARAM_NAME)) {
                        qValue = tokenizer.readQValue();
                    } else {
                        String paramValue = tokenizer.readParamValue();
                        extParams.add(new BasicImMapEntry((Object)paramName, (Object)paramValue));
                    }
                    ++nParam;
                }
                entries.add(new MediaTypeEntry(type, subtype, qValue, (ImList<? extends ImMapEntry<String, String>>)ImCollections.toList(extParams)));
            }
            tokenizer.assertEnd();
        }
    }

    public static int findFirstValid(List<MediaTypeEntry> entries, String parameterName, IntPredicate paramPredicate) {
        for (MediaTypeEntry entry : entries) {
            String vString = entry.getParameterValue(parameterName);
            if (vString == null) continue;
            try {
                int v = Integer.parseInt(vString);
                if (!paramPredicate.test(v)) continue;
                return v;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static final class HeaderBuilder {
        private final StringBuilder sb = new StringBuilder();

        public void newEntry(String value) {
            if (this.sb.length() > 0) {
                this.sb.append(',');
            }
            this.sb.append(value);
        }

        public void newEntry(String value, float qValue) {
            this.newEntry(value);
            this.sb.append(';');
            this.sb.append(HttpHeaderUtils.QUALITY_FACTOR_PARAM_NAME);
            this.sb.append('=');
            this.sb.append(qValue);
        }

        public void addParameter(String name, String value) {
            this.sb.append(';');
            this.sb.append(name);
            this.sb.append('=');
            this.sb.append(value);
        }

        public String build() {
            return this.sb.toString();
        }
    }

    public static class MediaTypeEntry
    extends BasicMediaType
    implements Comparable<MediaTypeEntry> {
        private final float qualityFactor;

        public MediaTypeEntry(String type, String subtype, float qualityFactor, ImList<? extends ImMapEntry<String, String>> extParams) {
            super(type, subtype, extParams);
            this.qualityFactor = qualityFactor;
        }

        public float getQualityFactor() {
            return this.qualityFactor;
        }

        @Override
        public int compareTo(MediaTypeEntry o) {
            float diff = this.qualityFactor - o.qualityFactor;
            if (diff != 0.0f) {
                return diff > 0.0f ? -1 : 1;
            }
            int diff2 = MediaTypeEntry.compare(this.getType(), o.getType());
            if (diff2 != 0) {
                return diff2;
            }
            diff2 = MediaTypeEntry.compare(this.getSubtype(), o.getSubtype());
            if (diff2 != 0) {
                return diff2;
            }
            return -(this.getParameters().size() - o.getParameters().size());
        }
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String errorDescription;
        private final String input;
        private final int errorOffset;

        public ParseException(String errorDescription, String input, int errorOffset) {
            super(String.format("Parse error: %1$s at %3$s in:\n%2$s", errorDescription, input, errorOffset));
            this.errorDescription = errorDescription;
            this.input = input;
            this.errorOffset = errorOffset;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public String getInput() {
            return this.input;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }
    }

    private static class Tokenizer {
        private final String input;
        private int index;

        private static boolean isLinearWhitespace(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        private static boolean isSeparator(char c) {
            switch (c) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return false;
        }

        public Tokenizer(String input) {
            this.input = input;
        }

        private int consumeWhitespace(int idx) {
            while (idx < this.input.length() && Tokenizer.isLinearWhitespace(this.input.charAt(idx))) {
                ++idx;
            }
            return idx;
        }

        private int consumeToken(int idx) {
            while (idx < this.input.length()) {
                char c = this.input.charAt(idx);
                if (c <= ' ' || c >= '\u007f' || Tokenizer.isSeparator(c)) break;
                ++idx;
            }
            return idx;
        }

        public void readOperatorAssert(char c) throws ParseException {
            int idx = this.index;
            if ((idx = this.consumeWhitespace(idx)) < this.input.length() && this.input.charAt(idx) == c) {
                this.index = idx + 1;
                return;
            }
            throw new ParseException("operator '" + c + "' expected", this.input, idx);
        }

        public String readTokenAssert() throws ParseException {
            int idx = this.index;
            int start = idx = this.consumeWhitespace(idx);
            if (start < (idx = this.consumeToken(idx))) {
                this.index = idx;
                return this.input.substring(start, idx);
            }
            throw new ParseException("token expected", this.input, idx);
        }

        private String readParamValue(int idx) throws ParseException {
            if (idx < this.input.length()) {
                if (this.input.charAt(idx) == '\"') {
                    int start = ++idx;
                    int end = -1;
                    block4: while (idx < this.input.length()) {
                        char c = this.input.charAt(idx);
                        switch (c) {
                            case '\"': {
                                end = idx++;
                                break;
                            }
                            case '\\': {
                                if (++idx >= this.input.length()) continue block4;
                                ++idx;
                                break;
                            }
                            default: {
                                ++idx;
                            }
                        }
                    }
                    this.index = idx;
                    if (end >= 0) {
                        return this.input.substring(start, end);
                    }
                    throw new ParseException("closing quote ('\"') expected", this.input, idx);
                }
                int start = idx;
                this.index = idx = this.consumeToken(idx);
                return this.input.substring(start, idx);
            }
            this.index = idx;
            return "";
        }

        public String readParamValue() throws ParseException {
            int idx = this.index;
            idx = this.consumeWhitespace(idx);
            return this.readParamValue(idx);
        }

        public void skipParamValue() throws ParseException {
            int idx = this.index;
            if ((idx = this.consumeWhitespace(idx)) < this.input.length()) {
                if (this.input.charAt(idx) == '\"') {
                    ++idx;
                    int end = -1;
                    block4: while (idx < this.input.length()) {
                        char c = this.input.charAt(idx);
                        switch (c) {
                            case '\"': {
                                end = idx++;
                                break;
                            }
                            case '\\': {
                                if (++idx >= this.input.length()) continue block4;
                                ++idx;
                                break;
                            }
                            default: {
                                ++idx;
                            }
                        }
                    }
                    this.index = idx;
                    if (end >= 0) {
                        return;
                    }
                    throw new ParseException("closing quote ('\"') expected", this.input, idx);
                }
                this.index = idx = this.consumeToken(idx);
                return;
            }
            this.index = idx;
        }

        public float readQValue() throws ParseException {
            int idx = this.index;
            int start = idx = this.consumeWhitespace(idx);
            try {
                this.index = idx = this.consumeToken(idx);
                return Float.parseFloat(this.input.substring(start, idx));
            }
            catch (NumberFormatException e) {
                throw new ParseException("q value (number) expected", this.input, start);
            }
        }

        public boolean readNextEntry() {
            int idx = this.index;
            if ((idx = this.consumeWhitespace(idx)) < this.input.length()) {
                if (this.index == 0) {
                    return true;
                }
                if (this.input.charAt(idx) == ',') {
                    this.index = idx + 1;
                    return true;
                }
            }
            this.index = idx;
            return false;
        }

        public boolean readNextParam() {
            int idx = this.index;
            if ((idx = this.consumeWhitespace(idx)) < this.input.length() && this.input.charAt(idx) == ';') {
                this.index = idx + 1;
                return true;
            }
            this.index = idx;
            return false;
        }

        public void assertEnd() throws ParseException {
            int idx = this.index;
            this.index = idx = this.consumeWhitespace(idx);
            if (idx == this.input.length()) {
                return;
            }
            throw new ParseException("EOF expected", this.input, idx);
        }
    }
}

