/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.update;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.index.AbortIndexOperationException;
import org.eclipse.statet.internal.rhelp.core.index.RDocResource;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexWriter;
import org.eclipse.statet.internal.rhelp.core.index.RHelpHtmlUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.rhelp.core.DocResource;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.renv.core.BasicRPkgDescription;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkgBuilt;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgDescription;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public abstract class REnvIndexUpdater {
    private static final String PKG_DESCR_FNAME = "rj:::rhelp.loadPkgDescr";
    private static final int PKG_DESCR_LENGTH = 7;
    private static final int PKG_DESCR_IDX_VERSION = 0;
    private static final int PKG_DESCR_IDX_TITLE = 1;
    private static final int PKG_DESCR_IDX_DESCRIPTION = 2;
    private static final int PKG_DESCR_IDX_AUTHOR = 3;
    private static final int PKG_DESCR_IDX_MAINTAINER = 4;
    private static final int PKG_DESCR_IDX_URL = 5;
    private static final int PKG_DESCR_IDX_BUILT = 6;
    private static final String PKG_RD_FNAME = "rj:::rhelp.loadPkgRd";
    private static final char HTML_NL = '\n';
    private static final Pattern HTML_PAGE_STRIP_PATTERN = Pattern.compile("\\A\\Q<p><a href='../Example/\\E.*\\Q</a></p>\\E");
    private static final PkgTask STOP_OK = new PkgTask("STOP_OK");
    private static final PkgTask STOP_CANCEL = new PkgTask("STOP_CANCEL");
    private final REnvHelpConfiguration rEnvConfig;
    private final StringBuilder tempBuilder1 = new StringBuilder(65536);
    private final StringBuilder tempBuilder2 = new StringBuilder(1024);
    private final REnvIndexWriter index;
    private final RPkgManager rPkgManager;
    private static final Pattern URL_SPLIT_PATTERN = Pattern.compile("(?:,|\\s)+");

    private static @Nullable String checkNA2Null(@Nullable String s) {
        return s != null && !s.equals("NA") && s.length() > 0 ? s : null;
    }

    public REnvIndexUpdater(REnvHelpConfiguration rEnvConfig, RHelpManager rHelpManager, RPkgManager rPkgManager) {
        this.rEnvConfig = rEnvConfig;
        this.index = new REnvIndexWriter(rEnvConfig, rHelpManager);
        this.rPkgManager = rPkgManager;
    }

    protected RPkgManager getRPkgManager() {
        return this.rPkgManager;
    }

    public Status update(RService r, boolean reset, @Nullable Map<String, String> rEnvSharedProperties, ProgressMonitor m) {
        m.setWorkRemaining(10);
        try {
            Status status;
            this.index.beginBatch(reset);
            String docDir = REnvIndexUpdater.checkNA2Null(RDataUtils.checkSingleChar((RObject)r.evalData("R.home(\"doc\")", m)));
            this.index.setDocDir(docDir, docDir != null ? this.toLocalPath(docDir, r, m) : null);
            this.index.addManuals((Collection<DocResource>)RDocResource.R_MANUALS);
            this.index.addMiscResources((Collection<DocResource>)RDocResource.R_MISCS);
            this.index.setREnvSharedProperties(rEnvSharedProperties);
            long tKeywords = System.nanoTime();
            this.loadKeywords(r, m.newSubMonitor(1));
            tKeywords = System.nanoTime() - tKeywords;
            m.checkCanceled();
            long tPackages = System.nanoTime();
            this.loadPackages(r, m.newSubMonitor(8));
            tPackages = System.nanoTime() - tPackages;
            if (RHelpCoreInternals.DEBUG) {
                this.index.log((Status)new InfoStatus("org.eclipse.statet.rhelp.core", String.format("Required time for update: keywords= %1$sms, packages= %2$sms.", tKeywords / 1000000L, tPackages / 1000000L)));
            }
            if ((status = this.index.endBatch()) != null && status.getSeverity() >= 4) {
                return new WarningStatus("org.eclipse.statet.rhelp.core", "The R environment index could not be completely updated.", (Throwable)new StatusException(status));
            }
            return new InfoStatus("org.eclipse.statet.rhelp.core", "The R environment index was updated successfully.");
        }
        catch (StatusException e) {
            if (e.getStatus().getSeverity() == 8) {
                this.index.cancel();
                return e.getStatus();
            }
            this.index.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when updating the R environment.", (Throwable)e));
            Status status = this.index.cancel();
            return new ErrorStatus("org.eclipse.statet.rhelp.core", "The R environment could not be updated.", (Throwable)(status != null ? new StatusException(status) : null));
        }
        catch (Exception e) {
            this.index.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when updating the R environment.", (Throwable)e));
            Status status = this.index.cancel();
            return new ErrorStatus("org.eclipse.statet.rhelp.core", "The R environment could not be updated.", (Throwable)(status != null ? new StatusException(status) : null));
        }
    }

    private void loadKeywords(RService r, ProgressMonitor m) throws StatusException {
        String docDir = this.index.getDocDir();
        if (docDir == null) {
            return;
        }
        m.beginTask("Loading R help keywords...", 20);
        Throwable errorCause = null;
        try {
            String line;
            byte[] bytes = r.downloadFile(String.valueOf(docDir) + "/KEYWORDS.db", 0, m.newSubMonitor(10));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), "UTF-8"));
            this.tempBuilder1.setLength(0);
            while ((line = reader.readLine()) != null) {
                int idx;
                if (RHelpCoreInternals.DEBUG) {
                    this.tempBuilder1.append(line);
                    this.tempBuilder1.append('\n');
                }
                if ((idx = line.indexOf(35)) >= 0) {
                    line = line.substring(0, idx);
                }
                if ((idx = line.indexOf(58)) < 0) continue;
                String descr = line.substring(idx + 1).trim();
                line = line.substring(0, idx);
                this.index.addDefaultKeyword(line.split("\\|"), descr);
            }
            m.addWorked(10);
            return;
        }
        catch (StatusException e) {
            if (e.getStatus().getSeverity() == 8) {
                throw e;
            }
            errorCause = e;
        }
        catch (Exception e) {
            errorCause = e;
        }
        finally {
            if (RHelpCoreInternals.DEBUG) {
                this.tempBuilder1.insert(0, "Read KEYWORDS.db file:\n<FILE>\n");
                this.tempBuilder1.append("</FILE>\n");
                this.index.log((Status)new InfoStatus("org.eclipse.statet.rhelp.core", this.tempBuilder1.toString()));
            }
        }
        this.index.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when loading the keyword list.", errorCause));
    }

    private void loadPackages(RService r, ProgressMonitor m) throws StatusException {
        m.beginTask("Loading R package help.", 9);
        Throwable errorCause = null;
        IndexJob job = null;
        try {
            RPkgManagerDataset rPkgDataset = this.rPkgManager.getDataset(1, r, m);
            job = this.scheduleIndexJob(String.format("Update R help index for '%1$s'", this.rEnvConfig.getName()));
            RuntimeRLibPaths rLibPaths = (RuntimeRLibPaths)rPkgDataset.getRLibPaths();
            RPkgCompilation installed = rPkgDataset.getInstalled();
            ProgressMonitor mPkgs = m.newSubMonitor(8);
            List names = installed.getNames();
            int i = 0;
            while (i < names.size()) {
                mPkgs.setWorkRemaining(2 * (names.size() - i));
                RPkgBuilt pkgInfo = (RPkgBuilt)installed.getFirst((String)names.get(i));
                if (!this.index.checkPackage(pkgInfo.getName(), pkgInfo.getVersion(), pkgInfo.getBuilt(), pkgInfo.getLibLocation())) {
                    mPkgs.checkCanceled();
                    mPkgs.beginSubTask(String.format("Loading data for package '%1$s'...", pkgInfo.getName()));
                    try {
                        RLibLocationInfo libLocationInfo = rLibPaths.getInfo(pkgInfo.getLibLocation());
                        if (libLocationInfo == null) {
                            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("Failed to resolve library location '%1$s'.", pkgInfo.getLibLocation())));
                        }
                        PkgTask task = new PkgTask(pkgInfo.getName(), pkgInfo.getVersion(), pkgInfo.getBuilt(), pkgInfo.getLibLocation(), libLocationInfo);
                        FunctionCall call = r.createFunctionCall(PKG_DESCR_FNAME);
                        call.addChar("lib", libLocationInfo.getDirectoryRPath());
                        call.addChar("name", pkgInfo.getName());
                        task.rDescr = RDataUtils.checkRCharVector((RObject)call.evalData(mPkgs.newSubMonitor(1)));
                        call = r.createFunctionCall(PKG_RD_FNAME);
                        call.addChar("lib", libLocationInfo.getDirectoryRPath());
                        call.addChar("name", pkgInfo.getName());
                        task.rRd = RDataUtils.checkRList((RObject)call.evalData(mPkgs.newSubMonitor(1)));
                        job.add(task, mPkgs);
                    }
                    catch (StatusException e) {
                        if (e.getStatus().getSeverity() == 8) {
                            throw e;
                        }
                        this.index.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when loading data for package '%1$s' in '%2$s'.", pkgInfo.getName(), pkgInfo.getLibLocation()), (Throwable)e));
                    }
                }
                ++i;
            }
            m.beginSubTask("Finishing index of help...");
            job.finish(m.newSubMonitor(2));
            job = null;
            return;
        }
        catch (StatusException e) {
            if (e.getStatus().getSeverity() == 8) {
                throw e;
            }
            errorCause = e;
        }
        catch (Exception e) {
            errorCause = e;
        }
        finally {
            if (job != null) {
                job.cancel(m);
            }
        }
        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when loading the package data.", errorCause));
    }

    protected abstract IndexJob scheduleIndexJob(String var1);

    private RPkgDescription createDescription(PkgTask task) throws Exception {
        String built;
        RNumVersion version;
        RCharacterStore data = (RCharacterStore)RDataUtils.checkLengthEqual((RStore)((RCharacterStore)task.rDescr.getData()), (long)7L);
        String versionString = (String)RDataUtils.checkValue((RStore)data, (int)0);
        RNumVersion taskVersion = task.version;
        if (taskVersion != null) {
            if (!taskVersion.toString().equals(versionString)) {
                throw new Exception(String.format("Unexpected package version: expected=%1$s, found=%2$s", taskVersion, versionString));
            }
            version = taskVersion;
        } else {
            version = RNumVersion.create((String)versionString);
        }
        String builtString = (String)RDataUtils.checkValue((RStore)data, (int)6);
        String taskBuilt = task.built;
        if (taskBuilt != null) {
            if (!taskBuilt.equals(builtString)) {
                throw new Exception(String.format("Unexpected package built: expected=%1$s, found=%2$s", taskBuilt, builtString));
            }
            built = taskBuilt;
        } else {
            built = builtString;
        }
        String urlString = data.get(5);
        ImList urls = urlString != null && !(urlString = urlString.strip()).isEmpty() ? ImCollections.newList((Object[])URL_SPLIT_PATTERN.split(urlString)) : ImCollections.emptyList();
        return new BasicRPkgDescription(task.name, version, (String)RDataUtils.getValue((RStore)data, (int)1, (Object)""), (String)RDataUtils.getValue((RStore)data, (int)2, (Object)""), data.get(3), data.get(4), urls, built, task.libLocation);
    }

    private void processRdData(String pkgName, RList pkgList) throws Exception {
        int j = 0;
        while ((long)j < pkgList.getLength()) {
            RObject rdObj = pkgList.get(j);
            if (rdObj.getRClassName().equals("RdData")) {
                RList rdData = (RList)rdObj;
                REnvIndexWriter.RdItem rdItem = new REnvIndexWriter.RdItem(pkgName, pkgList.getName(j));
                RStore store = rdData.get("title").getData();
                if (!store.isNA(0)) {
                    rdItem.setTitle(store.getChar(0));
                }
                store = rdData.get("topics").getData();
                int k = 0;
                while ((long)k < store.getLength()) {
                    String alias;
                    if (!store.isNA(k) && (alias = store.getChar(k).trim()).length() > 0) {
                        rdItem.addTopic(alias);
                    }
                    ++k;
                }
                store = rdData.get("keywords").getData();
                k = 0;
                while ((long)k < store.getLength()) {
                    String keyword;
                    if (!store.isNA(k) && (keyword = store.getChar(k).trim()).length() > 0) {
                        rdItem.addKeyword(keyword);
                    }
                    ++k;
                }
                store = rdData.get("concepts").getData();
                k = 0;
                while ((long)k < store.getLength()) {
                    String concept;
                    if (!store.isNA(k) && (concept = store.getChar(k).trim()).length() > 0) {
                        rdItem.addConcept(concept);
                    }
                    ++k;
                }
                store = rdData.get("HTML").getData();
                if (store != null && store.getStoreType() == 5) {
                    rdItem.setHtml(this.processHtml((RCharacterStore)store));
                }
                this.index.add(rdItem);
            }
            ++j;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String processHtml(RCharacterStore store) {
        docBuilder = this.tempBuilder1;
        docBuilder.setLength(0);
        tocBuilder = this.tempBuilder2;
        tocBuilder.setLength(0);
        length = 0;
        i = 0;
        while ((long)i < store.getLength()) {
            if (!store.isNA(i)) {
                length += store.getChar(i).length() + 2;
            }
            ++i;
        }
        tocBuilder.ensureCapacity(length += 300);
        stripMatcher = REnvIndexUpdater.HTML_PAGE_STRIP_PATTERN.matcher("");
        hrMatcher = RHelpHtmlUtils.HR_LINE_PATTERN.matcher("");
        topIndex = -1;
        inExamples = false;
        tocBuilder.append("<div class=\"toc\"><ul>");
        i = 0;
        while ((long)i < store.getLength()) {
            block23: {
                block28: {
                    block25: {
                        block27: {
                            block26: {
                                block24: {
                                    if (store.isNA(i)) break block23;
                                    line = store.getChar(i);
                                    if (!line.isEmpty()) break block24;
                                    docBuilder.append('\n');
                                    break block23;
                                }
                                if (topIndex != -1) break block25;
                                if (line.contains("/doc/html/prism.")) break block23;
                                if (!line.startsWith("<table ")) break block26;
                                docBuilder.append("<table class=\"header\" ");
                                docBuilder.append(line, 7, line.length());
                                docBuilder.append('\n');
                                break block23;
                            }
                            if (!line.startsWith("<h2>")) break block27;
                            topIndex = docBuilder.length();
                            docBuilder.append("<h2 id=\"top\">");
                            docBuilder.append(line, 4, line.length());
                            docBuilder.append('\n');
                            break block23;
                        }
                        idx = line.indexOf("=\"/doc/html/");
                        if (idx < 0) ** GOTO lbl-1000
                        docBuilder.append(line, 0, idx + 2);
                        docBuilder.append("../../..");
                        docBuilder.append(line, idx + 2, line.length());
                        docBuilder.append('\n');
                        break block23;
                    }
                    if (topIndex < 0 || line.length() <= 10) ** GOTO lbl-1000
                    if (!line.startsWith("<h3>")) break block28;
                    if (inExamples) {
                        docBuilder.append("<!-- END-EXAMPLES -->\n");
                        inExamples = false;
                    }
                    switch (line.charAt(4) - line.charAt(6)) {
                        case -47: {
                            if (!line.equals("<h3>Description</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#description\"><span class=\"mnemonic\">D</span>escription</a></li>");
                            docBuilder.append("<h3 id=\"description\">Description</h3>\n");
                            break block23;
                        }
                        case -12: {
                            if (!line.equals("<h3>Usage</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#usage\"><span class=\"mnemonic\">U</span>sage</a></li>");
                            docBuilder.append("<h3 id=\"usage\">Usage</h3>\n");
                            break block23;
                        }
                        case -38: {
                            if (!line.equals("<h3>Arguments</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#arguments\"><span class=\"mnemonic\">A</span>rguments</a></li>");
                            docBuilder.append("<h3 id=\"arguments\">Arguments</h3>\n");
                            break block23;
                        }
                        case -48: {
                            if (!line.equals("<h3>Details</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#details\">Deta<span class=\"mnemonic\">i</span>ls</a></li>");
                            docBuilder.append("<h3 id=\"details\">Details</h3>\n");
                            break block23;
                        }
                        case -22: {
                            if (!line.equals("<h3>Value</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#value\"><span class=\"mnemonic\">V</span>alue</a></li>");
                            docBuilder.append("<h3 id=\"value\">Value</h3>\n");
                            break block23;
                        }
                        case -51: {
                            if (!line.equals("<h3>Author(s)</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#authors\">Auth<span class=\"mnemonic\">o</span>r(s)</a></li>");
                            docBuilder.append("<h3 id=\"authors\">Author(s)</h3>\n");
                            break block23;
                        }
                        case -20: {
                            if (!line.equals("<h3>References</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#references\"><span class=\"mnemonic\">R</span>eferences</a></li>");
                            docBuilder.append("<h3 id=\"references\">References</h3>\n");
                            break block23;
                        }
                        case -28: {
                            if (!line.equals("<h3>Examples</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#examples\"><span class=\"mnemonic\">E</span>xamples</a></li>");
                            docBuilder.append("<h3 id=\"examples\">Examples<!-- EXAMPLES-ADD --></h3><!-- BEGIN-EXAMPLES -->\n");
                            inExamples = true;
                            break block23;
                        }
                        case -18: {
                            if (!line.equals("<h3>See Also</h3>")) ** GOTO lbl-1000
                            tocBuilder.append("<li><a href=\"#seealso\"><span class=\"mnemonic\">S</span>ee Also</a></li>");
                            docBuilder.append("<h3 id=\"seealso\">See Also</h3>\n");
                            break block23;
                        }
                    }
                    ** GOTO lbl-1000
                }
                if (line.startsWith("<hr") && hrMatcher.reset(line).find()) {
                    if (inExamples) {
                        docBuilder.append("<!-- END-EXAMPLES -->\n");
                        inExamples = false;
                    }
                    docBuilder.append("<hr/>");
                    if (hrMatcher.end() < line.length()) {
                        docBuilder.append(line, hrMatcher.end(), line.length());
                    }
                    docBuilder.append('\n');
                } else if (stripMatcher.reset(line).find()) {
                    if (stripMatcher.end() < line.length()) {
                        docBuilder.append(line, stripMatcher.end(), line.length());
                        docBuilder.append('\n');
                    }
                } else {
                    docBuilder.append(line);
                    docBuilder.append('\n');
                }
            }
            ++i;
        }
        if (topIndex >= 0) {
            tocBuilder.append("</ul></div>\n");
            docBuilder.insert(topIndex, tocBuilder);
        }
        return docBuilder.toString();
    }

    protected Path toLocalPath(String rPath, RService r, ProgressMonitor m) throws StatusException {
        return Path.of(rPath, new String[0]);
    }

    protected abstract class IndexJob {
        private final BlockingQueue<PkgTask> queue = new ArrayBlockingQueue<PkgTask>(4);
        private volatile @Nullable Exception exception;
        private int count;
        private int queueCumCount;

        protected abstract void cancel();

        protected abstract void join();

        private void add(PkgTask task, ProgressMonitor m) throws Exception {
            while (true) {
                try {
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    ++this.count;
                    this.queueCumCount += this.queue.size();
                    this.queue.put(task);
                }
                catch (InterruptedException e) {
                    if (!m.isCanceled()) continue;
                    this.cancel();
                    throw new StatusException(Status.CANCEL_STATUS);
                }
                break;
            }
        }

        private void finish(ProgressMonitor m) throws StatusException {
            while (true) {
                try {
                    this.queue.put(STOP_OK);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.join();
        }

        private void cancel(ProgressMonitor m) {
            this.cancel();
            while (true) {
                try {
                    this.queue.put(STOP_CANCEL);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.join();
        }

        /*
         * Loose catch block
         * Enabled aggressive exception aggregation
         */
        public Status run(ProgressMonitor monitor) {
            try {
                PkgTask task = null;
                do {
                    block30: {
                        block29: {
                            task = this.queue.take();
                            if (task != STOP_OK) break block29;
                            if (RHelpCoreInternals.DEBUG) {
                                REnvIndexUpdater.this.index.log((Status)new InfoStatus("org.eclipse.statet.rhelp.core", String.format("Fill level of queue: mean= %1.2f.", (double)this.queueCumCount / (double)this.count)));
                            }
                            Status status = Status.OK_STATUS;
                            try {
                                REnvIndexUpdater.this.index.endPackage();
                            }
                            catch (Exception e) {
                                this.exception = e;
                                this.queue.clear();
                                return Status.CANCEL_STATUS;
                            }
                            return status;
                        }
                        if (task != STOP_CANCEL) break block30;
                        Status status = Status.CANCEL_STATUS;
                        try {
                            REnvIndexUpdater.this.index.endPackage();
                        }
                        catch (Exception e) {
                            this.exception = e;
                            this.queue.clear();
                            return Status.CANCEL_STATUS;
                        }
                        return status;
                    }
                    try {
                        RPkgDescription pkgDescription = REnvIndexUpdater.this.createDescription(task);
                        REnvIndexUpdater.this.index.beginPackage(pkgDescription);
                        REnvIndexUpdater.this.processRdData(pkgDescription.getName(), task.rRd);
                    }
                    catch (InterruptedException pkgDescription) {
                        try {
                            REnvIndexUpdater.this.index.endPackage();
                            continue;
                        }
                        catch (Exception e) {
                            this.exception = e;
                            this.queue.clear();
                            return Status.CANCEL_STATUS;
                        }
                    }
                    catch (AbortIndexOperationException e) {
                        this.exception = e;
                        this.queue.clear();
                        Status status = Status.CANCEL_STATUS;
                        return status;
                    }
                    catch (Exception e) {
                        REnvIndexUpdater.this.index.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when indexing data for package: %1$s", task), (Throwable)e));
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        try {
                            REnvIndexUpdater.this.index.endPackage();
                            continue;
                        }
                        catch (Exception e2) {
                            this.exception = e2;
                            this.queue.clear();
                            return Status.CANCEL_STATUS;
                        }
                    }
                    {
                        finally {
                            try {
                                REnvIndexUpdater.this.index.endPackage();
                            }
                            catch (Exception e) {
                                this.exception = e;
                                this.queue.clear();
                                return Status.CANCEL_STATUS;
                            }
                        }
                    }
                    try {
                        REnvIndexUpdater.this.index.endPackage();
                    }
                    catch (Exception e) {
                        this.exception = e;
                        this.queue.clear();
                        return Status.CANCEL_STATUS;
                    }
                } while (!monitor.isCanceled());
                return Status.CANCEL_STATUS;
            }
            catch (Exception e) {
                this.exception = e;
                this.queue.clear();
                return Status.CANCEL_STATUS;
            }
        }
    }

    private static class PkgTask {
        final String name;
        final @Nullable RNumVersion version;
        final @Nullable String built;
        final RLibLocation libLocation;
        final RLibLocationInfo libLocationInfo;
        RVector<RCharacterStore> rDescr;
        RList rRd;

        public PkgTask(String name, RNumVersion version, String built, RLibLocation libLocation, RLibLocationInfo libLocationInfo) {
            this.name = name.intern();
            this.version = version;
            this.built = built;
            this.libLocation = libLocation;
            this.libLocationInfo = libLocationInfo;
        }

        private PkgTask(String signal) {
            this.name = signal;
            this.version = null;
            this.built = null;
            this.libLocation = null;
            this.libLocationInfo = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append(" (version= ").append(this.version != null ? this.version : "<unknown>");
            sb.append(')');
            if (this.libLocationInfo != null) {
                sb.append(" in lib= '").append(this.libLocationInfo.getDirectoryRPath()).append('\'');
            }
            return sb.toString();
        }
    }
}

