/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RComplexStore;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RRawStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;

@NonNullByDefault
public interface RObjectFactory {
    public static final int F_ONLY_STRUCT = 1;
    public static final int F_WITH_ATTR = 2;
    public static final int F_WITH_DBG = 4;
    public static final int F_LOAD_ENVIRONMENT = 16;
    public static final int F_LOAD_PROMISE = 32;
    public static final int O_LENGTHGRADE_MASK = 7;
    public static final int O_WITH_ATTR = 8;
    public static final int O_CLASS_NAME = 16;
    public static final int O_NO_CHILDREN = 32;
    public static final int O_WITH_NAMES = 64;

    public <TData extends RStore<?>> RVector<TData> createVector(TData var1);

    public <TData extends RStore<?>> RArray<TData> createArray(TData var1, int[] var2);

    public <TData extends RStore<?>> RArray<TData> createMatrix(TData var1, int var2, int var3);

    public RList createList(RObject[] var1, @Nullable String @Nullable [] var2);

    public RLanguage createName(String var1);

    public RLanguage createExpression(String var1);

    public RLogicalStore createLogiData(boolean[] var1);

    public RIntegerStore createIntData(int[] var1);

    public RNumericStore createNumData(double[] var1);

    public RComplexStore createCplxData(double[] var1, double[] var2);

    public RCharacterStore createCharData(@Nullable String[] var1);

    default public RCharacterStore createCharDataUtf8(byte[] @Nullable [] charValues) {
        int length = charValues.length;
        @Nullable String[] charValuesJava = new String[length];
        int i = 0;
        while (i < length) {
            byte[] charValue = charValues[i];
            if (charValue != null) {
                charValuesJava[i] = new String(charValue, StandardCharsets.UTF_8);
            }
            ++i;
        }
        return this.createCharData(charValuesJava);
    }

    public RRawStore createRawData(byte[] var1);

    public RFactorStore createFactorData(int[] var1, @Nullable String[] var2);

    public void writeObject(RObject var1, RJIO var2) throws IOException;

    public RObject readObject(RJIO var1) throws IOException;

    public void writeStore(RStore<?> var1, RJIO var2) throws IOException;

    public RStore<?> readStore(RJIO var1, long var2) throws IOException;

    public void writeAttributeList(RList var1, RJIO var2) throws IOException;

    public RList readAttributeList(RJIO var1) throws IOException;

    public void writeNames(@Nullable RStore<?> var1, RJIO var2) throws IOException;

    public @Nullable RStore<?> readNames(RJIO var1, long var2) throws IOException;
}

