/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsComObject;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.dbg.CallStack;
import org.eclipse.statet.rj.server.dbg.CtrlReport;
import org.eclipse.statet.rj.server.dbg.DbgEnablement;
import org.eclipse.statet.rj.server.dbg.DbgFilterState;
import org.eclipse.statet.rj.server.dbg.DbgRequest;
import org.eclipse.statet.rj.server.dbg.ElementTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.FlagTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.FrameContext;
import org.eclipse.statet.rj.server.dbg.FrameContextDetailRequest;
import org.eclipse.statet.rj.server.dbg.SetDebugReport;
import org.eclipse.statet.rj.server.dbg.SetDebugRequest;
import org.eclipse.statet.rj.server.dbg.TracepointEvent;
import org.eclipse.statet.rj.server.dbg.TracepointStatesUpdate;

@NonNullByDefault
public final class DbgCmdItem
extends MainCmdItem
implements RjsComObject,
Externalizable {
    public static final byte OP_LOAD_FRAME_LIST = 1;
    public static final byte OP_LOAD_FRAME_CONTEXT = 2;
    public static final byte OP_SET_DEBUG = 3;
    public static final byte OP_REQUEST_SUSPEND = 4;
    public static final byte OP_CTRL_RESUME = 9;
    public static final byte OP_CTRL_STEP_INTO = 10;
    public static final byte OP_CTRL_STEP_OVER = 12;
    public static final byte OP_CTRL_STEP_RETURN = 14;
    public static final byte OP_INSTALL_TP_FLAGS = 16;
    public static final byte OP_INSTALL_TP_POSITIONS = 17;
    public static final byte OP_SET_ENABLEMENT = 25;
    public static final byte OP_RESET_FILTER_STATE = 26;
    public static final byte OP_UPDATE_TP_STATES = 28;
    public static final byte OP_C2S_S2C = 32;
    public static final byte OP_NOTIFY_TP_EVENTS = 65;
    private static final int OV_WITHDATA = 0x1000000;
    private static final int OV_WITHSTATUS = 0x8000000;
    private byte op;
    private Object data;
    private @Nullable RjsStatus status;

    private static @Nullable Object readRequestData(RJIO io, byte type) throws IOException {
        switch (type) {
            case 1: {
                return null;
            }
            case 2: {
                return new FrameContextDetailRequest(io);
            }
            case 3: {
                return new SetDebugRequest(io);
            }
            case 4: {
                return null;
            }
            case 9: {
                return new DbgRequest.Resume(io);
            }
            case 10: {
                return new DbgRequest.StepInto(io);
            }
            case 12: {
                return new DbgRequest.StepOver(io);
            }
            case 14: {
                return new DbgRequest.StepReturn(io);
            }
            case 25: {
                return new DbgEnablement(io);
            }
            case 26: {
                return new DbgFilterState(io);
            }
            case 16: {
                return new FlagTracepointInstallationRequest(io);
            }
            case 17: {
                return new ElementTracepointInstallationRequest(io);
            }
            case 28: {
                return new TracepointStatesUpdate(io);
            }
            case 65: {
                return DbgCmdItem.readTracepointEvents(io);
            }
        }
        throw new IOException("Unsupported type= " + type);
    }

    private static Object readAnswerData(RJIO io, byte type) throws IOException {
        switch (type) {
            case 1: {
                return new CallStack(io);
            }
            case 2: {
                return new FrameContext(io);
            }
            case 3: {
                return new SetDebugReport(io);
            }
            case 4: {
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                return new CtrlReport(io);
            }
            case 25: 
            case 26: {
                break;
            }
            case 16: 
            case 17: 
            case 28: {
                break;
            }
        }
        throw new IOException("Unsupported type= " + type);
    }

    private static void writeList(List<RJIOExternalizable> list, RJIO io) throws IOException {
        int l = list.size();
        io.writeInt(l);
        int i = 0;
        while (i < l) {
            list.get(i).writeExternal(io);
            ++i;
        }
    }

    private static List<TracepointEvent> readTracepointEvents(RJIO io) throws IOException {
        Object[] array = new TracepointEvent[io.readInt()];
        int i = 0;
        while (i < array.length) {
            array[i] = new TracepointEvent(io);
            ++i;
        }
        return ImCollections.newList((Object[])array);
    }

    public DbgCmdItem(byte op, int options, RJIOExternalizable data) {
        this.op = op;
        this.options = options & 0xFFFF;
        if (data != null) {
            this.options |= 0x1000000;
        }
        if (op < 65) {
            this.options |= Integer.MIN_VALUE;
        }
        this.data = data;
    }

    public DbgCmdItem(byte op, int options, List<? extends RJIOExternalizable> data) {
        assert (op == 65);
        this.op = op;
        this.options = options & 0xFFFF;
        if (data != null) {
            this.options |= 0x1000000;
        }
        if (op < 65) {
            this.options |= Integer.MIN_VALUE;
        }
        this.data = data;
    }

    public DbgCmdItem() {
    }

    public DbgCmdItem(RJIO io) throws IOException {
        this.readExternal(io);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeInt(this.options);
        io.writeByte(this.op);
        if ((this.options & 0x8000000) != 0) {
            this.status.writeExternal(io);
        } else if ((this.options & 0x1000000) != 0) {
            if (this.op == 65) {
                DbgCmdItem.writeList((List)this.data, io);
            } else {
                ((RJIOExternalizable)this.data).writeExternal(io);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        RJIO io = RJIO.get((ObjectOutput)out);
        int check = io.writeCheck1();
        this.writeExternal(io);
        io.writeCheck2(check);
        io.disconnect(out);
    }

    private void readExternal(RJIO io) throws IOException {
        this.options = io.readInt();
        this.op = io.readByte();
        if ((this.options & 0x8000000) != 0) {
            this.status = new RjsStatus(io);
        } else if ((this.options & 0x1000000) != 0) {
            this.data = (this.options & 0x40000000) == 0 ? DbgCmdItem.readRequestData(io, this.op) : DbgCmdItem.readAnswerData(io, this.op);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        RJIO io = RJIO.get((ObjectInput)in);
        int check = io.readCheck1();
        this.readExternal(io);
        io.readCheck2(check);
        io.disconnect(in);
    }

    @Override
    public int getComType() {
        return 6;
    }

    @Override
    public byte getCmdType() {
        return 20;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        assert (status != null);
        if (status == RjsStatus.OK_STATUS) {
            this.options = this.options & 0xF00FFFFF | 0x40000000;
            this.status = null;
            this.data = null;
        } else {
            this.options = this.options & 0xF00FFFFF | 0x48000000;
            this.status = status;
            this.data = null;
        }
    }

    public void setAnswer(@Nullable RJIOExternalizable data) {
        this.options = this.options & 0xF00FFFFF | 0x40000000;
        if (data != null) {
            this.options |= 0x1000000;
        }
        this.status = null;
        this.data = data;
    }

    @Override
    public byte getOp() {
        return this.op;
    }

    @Override
    public boolean isOK() {
        RjsStatus status = this.status;
        return status == null || status.getSeverity() == 0;
    }

    @Override
    public @Nullable RjsStatus getStatus() {
        return this.status;
    }

    @Override
    public @Nullable String getDataText() {
        return null;
    }

    @Override
    public byte @Nullable [] getDataTextUtf8() {
        return null;
    }

    public Object getData() {
        return this.data;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (!(other instanceof DbgCmdItem)) {
            return false;
        }
        DbgCmdItem otherItem = (DbgCmdItem)other;
        if (this.getOp() != otherItem.getOp()) {
            return false;
        }
        return this.options == otherItem.options;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("DbgCmdItem ");
        switch (this.op) {
            case 1: {
                sb.append("LOAD_FRAME_LIST");
                break;
            }
            case 2: {
                sb.append("LOAD_FRAME_CONTEXT");
                break;
            }
            case 3: {
                sb.append("SET_DEBUG");
                break;
            }
            case 4: {
                sb.append("REQUEST_SUSPEND");
                break;
            }
            case 9: {
                sb.append("CTRL_RESUME");
                break;
            }
            case 10: {
                sb.append("CTRL_STEP_INTO");
                break;
            }
            case 12: {
                sb.append("CTRL_STEP_OVER");
                break;
            }
            case 14: {
                sb.append("CTRL_STEP_RETURN");
                break;
            }
            case 16: {
                sb.append("INSTALL_TP_FLAGS");
                break;
            }
            case 17: {
                sb.append("INSTALL_TP_POSITIONS");
                break;
            }
            case 25: {
                sb.append("SET_ENABLEMENT");
                break;
            }
            case 26: {
                sb.append("RESET_FILTER_STATE");
                break;
            }
            case 28: {
                sb.append("UPDATE_TP_STATES");
                break;
            }
            case 65: {
                sb.append("NOTIFY_TP_EVENT");
                break;
            }
            default: {
                sb.append(this.op);
            }
        }
        sb.append("\n\toptions= 0x").append(Integer.toHexString(this.options));
        if ((this.options & 0x1000000) != 0) {
            sb.append("\n<DATA>\n");
            sb.append(this.data);
            sb.append("\n</DATA>");
        }
        return sb.toString();
    }
}

