/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status;

import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.CancelStatus;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.OkStatus;
import org.eclipse.statet.jcommons.status.WarningStatus;

@NonNullByDefault
public interface Status {
    public static final byte OK = 0;
    public static final byte INFO = 1;
    public static final byte WARNING = 2;
    public static final byte ERROR = 4;
    public static final byte CANCEL = 8;
    public static final Status OK_STATUS = new OkStatus("unknown", 0, "OK");
    public static final Status CANCEL_STATUS = new CancelStatus("unknown", 1, "Canceled");

    public byte getSeverity();

    public String getBundleId();

    public int getCode();

    public String getMessage();

    public @Nullable Throwable getException();

    public boolean isMultiStatus();

    public ImList<Status> getChildren();

    public static Status newStatus(int severity, String bundleId, int code, String message, @Nullable Throwable exception) {
        switch (severity) {
            case 0: {
                return new OkStatus(bundleId, code, message);
            }
            case 1: {
                return new InfoStatus(bundleId, code, message, exception);
            }
            case 2: {
                return new WarningStatus(bundleId, code, message, exception);
            }
            case 4: {
                return new ErrorStatus(bundleId, code, message, exception);
            }
            case 8: {
                return new CancelStatus(bundleId, code, message, exception);
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }

    public static Status newStatus(int severity, String bundleId, String message, @Nullable Throwable exception) {
        switch (severity) {
            case 0: {
                return new OkStatus(bundleId, message);
            }
            case 1: {
                return new InfoStatus(bundleId, message, exception);
            }
            case 2: {
                return new WarningStatus(bundleId, message, exception);
            }
            case 4: {
                return new ErrorStatus(bundleId, message, exception);
            }
            case 8: {
                return new CancelStatus(bundleId, message, exception);
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }

    public static Status newStatus(int severity, String bundleId, String message) {
        switch (severity) {
            case 0: {
                return new OkStatus(bundleId, message);
            }
            case 1: {
                return new InfoStatus(bundleId, message);
            }
            case 2: {
                return new WarningStatus(bundleId, message);
            }
            case 4: {
                return new ErrorStatus(bundleId, message);
            }
            case 8: {
                return new CancelStatus(bundleId, message);
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }
}

