/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.rmi;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;

@NonNullByDefault
public class RMIAddress {
    public static final Sec SSH = new Sec("ssh");
    public static final Sec SSL = new Sec("ssl");
    private static final int RESOLVE = 1;
    private static final int REGISTRY = 2;
    private static final int DEFAULT_PORT_NUM = 1099;
    public static final Port DEFAULT_PORT = new Port(1099);
    public static final String REGISTRY_NAME = "";
    private final @Nullable String host;
    private @Nullable InetAddress hostInetAddress;
    private final Port port;
    private final @Nullable Sec sec;
    private final String path;
    private @Nullable String address;
    private volatile @Nullable String ser;

    public static void validate(String address) throws MalformedURLException {
        try {
            new RMIAddress(address, 0);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public static RMIAddress parseRegistry(String address) throws MalformedURLException, UnknownHostException {
        return new RMIAddress(address, 3);
    }

    public static RMIAddress parseUnresolved(String address) throws MalformedURLException {
        try {
            return new RMIAddress(address, 0);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String checkChars(String s) throws MalformedURLException {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '?' || c == '#' || c == '[' || c == ']' || c == '@' || c == '!' || c == '$' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == ';' || c == '=' || c == '\"' || c == '\\') {
                throw new MalformedURLException("Character '" + c + "' is not allowed.");
            }
            ++i;
        }
        return s;
    }

    private static String checkNameChars(String s) throws IllegalArgumentException {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '?' || c == '#' || c == '[' || c == ']' || c == '@' || c == '!' || c == '$' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == ';' || c == '=' || c == '\"' || c == '\\') {
                throw new IllegalArgumentException("Character '" + c + "' is not allowed.");
            }
            ++i;
        }
        return s;
    }

    private static Port parsePort(String port) throws MalformedURLException {
        try {
            return Port.valueOf(port);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Invalid port: " + e.getLocalizedMessage());
        }
    }

    private static Port checkPort(Port port) {
        return port.get() == 1099 ? DEFAULT_PORT : port;
    }

    private static String build(@Nullable String host, int portNum, @Nullable String name) {
        StringBuilder sb = new StringBuilder("//");
        if (host != null) {
            sb.append(host);
        }
        sb.append(':');
        if (portNum >= 0) {
            sb.append(Integer.toString(portNum));
        }
        sb.append('/');
        if (name != null) {
            sb.append(name);
        }
        return sb.toString();
    }

    public RMIAddress(String address) throws UnknownHostException, MalformedURLException {
        this(address, 1);
    }

    public RMIAddress(@Nullable String host, int portNum, @Nullable String name) throws UnknownHostException, MalformedURLException {
        this(RMIAddress.build(host, portNum, name), 1);
    }

    public RMIAddress(InetAddress address, Port port, @Nullable Sec sec, String name) {
        this(address.getHostAddress(), address, RMIAddress.checkPort(port), sec, RMIAddress.checkNameChars(name));
    }

    @Deprecated
    public RMIAddress(InetAddress address, Port port, boolean isSsl, String name) {
        this(address.getHostAddress(), address, RMIAddress.checkPort(port), isSsl ? SSL : null, RMIAddress.checkNameChars(name));
    }

    public RMIAddress(InetAddress address, Port port, String name) {
        this(address.getHostAddress(), address, RMIAddress.checkPort(port), null, RMIAddress.checkNameChars(name));
    }

    public RMIAddress(RMIAddress registry, String name) {
        this(registry.host, registry.hostInetAddress, registry.port, registry.sec, RMIAddress.checkNameChars(name));
    }

    private RMIAddress(String address, int flags) throws UnknownHostException, MalformedURLException {
        address = RMIAddress.checkChars(address);
        if (address.startsWith("ssh:")) {
            address = address.substring(4);
            this.sec = SSH;
        } else if (address.startsWith("ssl:")) {
            address = address.substring(4);
            this.sec = SSL;
        } else {
            this.sec = null;
        }
        if (address.startsWith("rmi:")) {
            address = address.substring(4);
        }
        if (!address.startsWith("//")) {
            address = "//" + address;
        }
        int idxPort = address.indexOf(58, 2);
        int idxPath = address.indexOf(47, 2);
        if ((flags & 2) != 0) {
            if (idxPath > 0) {
                if (idxPort > 0) {
                    if (idxPath <= idxPort) {
                        throw new MalformedURLException();
                    }
                    this.host = 2 < idxPort ? address.substring(2, idxPort) : null;
                    this.port = idxPort + 1 < idxPath ? RMIAddress.checkPort(RMIAddress.parsePort(address.substring(idxPort + 1, idxPath))) : DEFAULT_PORT;
                } else {
                    this.host = 2 < idxPath ? address.substring(2, idxPath) : null;
                    this.port = DEFAULT_PORT;
                }
            } else if (idxPort > 0) {
                this.host = 2 < idxPort ? address.substring(2, idxPort) : null;
                this.port = idxPort + 1 < address.length() ? RMIAddress.checkPort(RMIAddress.parsePort(address.substring(idxPort + 1))) : DEFAULT_PORT;
            } else {
                this.host = 2 < address.length() ? address.substring(2) : null;
                this.port = DEFAULT_PORT;
            }
            this.path = REGISTRY_NAME;
        } else if (idxPath > 0) {
            if (idxPort > 0) {
                if (idxPath <= idxPort) {
                    throw new MalformedURLException();
                }
                this.host = 2 < idxPort ? address.substring(2, idxPort) : null;
                this.port = idxPort + 1 < idxPath ? RMIAddress.checkPort(RMIAddress.parsePort(address.substring(idxPort + 1, idxPath))) : DEFAULT_PORT;
            } else {
                this.host = 2 < idxPath ? address.substring(2, idxPath) : null;
                this.port = DEFAULT_PORT;
            }
            this.path = address.substring(idxPath + 1);
        } else {
            if (idxPort > 0) {
                throw new MalformedURLException("Missing path component (RMI service name)");
            }
            this.host = null;
            this.port = DEFAULT_PORT;
            this.path = address.substring(2);
        }
        if ((flags & 1) != 0) {
            this.hostInetAddress = this.resolveHostInetAddress();
        }
    }

    private RMIAddress(@Nullable String host, @Nullable InetAddress hostInetAddress, Port port, @Nullable Sec sec, String path) {
        this.host = host;
        this.hostInetAddress = hostInetAddress;
        this.port = port;
        this.sec = sec;
        this.path = path;
    }

    public boolean isResolved() {
        return this.hostInetAddress != null;
    }

    public RMIAddress resolve() throws UnknownHostException {
        if (this.hostInetAddress != null) {
            return this;
        }
        return new RMIAddress(this.host, this.resolveHostInetAddress(), this.port, this.sec, this.path);
    }

    private InetAddress resolveHostInetAddress() throws UnknownHostException {
        String host = this.host;
        return host == null || CommonsNet.isCommonLoopback(host) ? CommonsNet.getLocalLoopbackInetAddress() : InetAddress.getByName(host);
    }

    public String getHost() {
        String host = this.host;
        return host == null ? CommonsNet.LOCAL_LOOPBACK_STRING : host;
    }

    public InetAddress getHostInetAddress() {
        InetAddress hostInetAddress = this.hostInetAddress;
        if (hostInetAddress == null) {
            throw new UnsupportedOperationException("address is unresolved");
        }
        return hostInetAddress;
    }

    public boolean isLocalHost() {
        String host = this.host;
        if (host == null) {
            return true;
        }
        InetAddress hostInetAddress = this.hostInetAddress;
        if (hostInetAddress != null && hostInetAddress.isLoopbackAddress()) {
            return true;
        }
        return CommonsNet.isLocalLocalhost(host);
    }

    public Port getPort() {
        return this.port;
    }

    public int getPortNum() {
        return this.port.get();
    }

    public @Nullable Sec getSec() {
        return this.sec;
    }

    public String getName() {
        return this.path;
    }

    public String getAddress() {
        String address = this.address;
        if (address == null) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("rmi://");
            if (this.host != null) {
                sb.append(this.host);
            }
            if (this.port != DEFAULT_PORT) {
                sb.append(':');
                sb.append(this.port);
            }
            sb.append('/');
            sb.append(this.path);
            this.address = address = sb.toString();
        }
        return address;
    }

    public RMIAddress getRegistryAddress() {
        return new RMIAddress(this.host, this.hostInetAddress, this.port, this.sec, REGISTRY_NAME);
    }

    public Remote lookup() throws RemoteException, NotBoundException, AccessException {
        RMIRegistry rmiRegistry = new RMIRegistry(this.getRegistryAddress(), false);
        return rmiRegistry.getRegistry().lookup(this.getName());
    }

    public boolean isSsl() {
        return this.sec == SSL;
    }

    public String toString() {
        String ser = this.ser;
        if (ser == null) {
            ser = this.getAddress();
            Sec sec = this.sec;
            if (sec != null) {
                ser = String.valueOf(sec.scheme) + ':' + ser;
            }
            this.ser = ser;
        }
        return ser;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RMIAddress) {
            RMIAddress other = (RMIAddress)obj;
            return Objects.equals(this.host, other.host) && this.port.equals(other.port) && this.sec == other.sec && this.path.equals(other.path) && Objects.equals(this.hostInetAddress, other.hostInetAddress);
        }
        return false;
    }

    public static class Sec {
        private final String scheme;

        public Sec(String scheme) {
            this.scheme = scheme;
        }

        public String toString() {
            return this.scheme;
        }
    }
}

