/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.core.shiny;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RShinyResourceTester
extends PropertyTester {
    private static final IPath APP_FILE_PATH = new Path("app.R");
    private static final IPath UI_FILE_PATH = new Path("ui.R");
    private static final IPath SERVER_FILE_PATH = new Path("server.R");

    private static final IContainer getContainer(IResource resource) {
        return resource instanceof IContainer ? (IContainer)resource : resource.getParent();
    }

    public static final boolean isAppContainer(IContainer container) {
        return container.getFile(SERVER_FILE_PATH).exists() && container.getFile(UI_FILE_PATH).exists() || container.getFile(APP_FILE_PATH).exists();
    }

    public static final @Nullable IContainer getAppContainer(IContainer container) {
        while (true) {
            if (RShinyResourceTester.isAppContainer(container)) {
                return container;
            }
            if (container.getType() != 2) break;
            container = container.getParent();
        }
        return null;
    }

    public static final boolean isInsideAppContainer(IResource resource) {
        return RShinyResourceTester.getAppContainer(RShinyResourceTester.getContainer(resource)) != null;
    }

    public static final @Nullable IContainer getAppContainer(IResource resource) {
        return RShinyResourceTester.getAppContainer(RShinyResourceTester.getContainer(resource));
    }

    public boolean test(Object receiver, String property, Object[] args, @Nullable Object expectedValue) {
        block7: {
            if (!(receiver instanceof IResource)) break block7;
            IResource resource = (IResource)receiver;
            switch (property) {
                case "isRShinyAppResource": {
                    return RShinyResourceTester.isInsideAppContainer(resource);
                }
            }
        }
        return false;
    }
}

