/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceObjectCache;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class PreferenceAccessWrapper
extends PreferenceObjectCache
implements PreferenceAccess,
PreferenceObjectAccess {
    private volatile boolean isDisposed;
    private volatile ImList<IScopeContext> contexts;
    private final List<ListenerItem> listeners = new ArrayList<ListenerItem>();

    public PreferenceAccessWrapper(ImList<IScopeContext> contexts) {
        this.contexts = contexts;
    }

    public PreferenceAccessWrapper() {
        this.contexts = ImCollections.emptyList();
    }

    @Override
    public final PreferenceAccess getPrefs() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPreferenceContexts(ImList<IScopeContext> contexts) {
        if (this.isDisposed() || this.contexts.equals(contexts)) {
            return;
        }
        this.contexts = contexts;
        PreferenceSetService service = EPreferences.getPreferenceSetService();
        if (service != null) {
            List<ListenerItem> list = this.listeners;
            synchronized (list) {
                int l = this.listeners.size();
                int i = 0;
                while (i < l) {
                    ListenerItem item = this.listeners.get(i);
                    service.addChangeListener(item.listener, contexts, item.qualifiers);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.isDisposed = true;
        this.contexts = ImCollections.emptyList();
        PreferenceSetService service = EPreferences.getPreferenceSetService();
        if (service != null) {
            List<ListenerItem> list = this.listeners;
            synchronized (list) {
                int l = this.listeners.size();
                int i = 0;
                while (i < l) {
                    ListenerItem item = this.listeners.get(i);
                    service.removeChangeListener(item.listener);
                    ++i;
                }
                this.listeners.clear();
            }
        }
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public final ImList<IScopeContext> getPreferenceContexts() {
        return this.contexts;
    }

    @Override
    public final <T> T getPreferenceValue(Preference<T> pref) {
        return PreferenceUtils.getPrefValue(this.contexts, pref);
    }

    @Override
    public void addPreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreferenceSetListener(PreferenceSetService.ChangeListener listener, ImSet<String> qualifiers) {
        block14: {
            if (listener == null) {
                throw new NullPointerException("listener");
            }
            if (qualifiers == null) {
                throw new NullPointerException("qualifiers");
            }
            List<ListenerItem> list = this.listeners;
            synchronized (list) {
                if (this.isDisposed()) {
                    return;
                }
                int l = this.listeners.size();
                int i = 0;
                while (i < l) {
                    ListenerItem item = this.listeners.get(i);
                    if (item.listener == listener) {
                        if (item.qualifiers.equals(qualifiers)) {
                            return;
                        }
                        item.qualifiers = qualifiers;
                        break block14;
                    }
                    ++i;
                }
                this.listeners.add(new ListenerItem(listener, qualifiers));
            }
        }
        PreferenceSetService service = EPreferences.getPreferenceSetService();
        if (service != null) {
            PreferenceAccessWrapper preferenceAccessWrapper = this;
            synchronized (preferenceAccessWrapper) {
                if (this.isDisposed()) {
                    return;
                }
                service.addChangeListener(listener, this.contexts, qualifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreferenceSetListener(PreferenceSetService.ChangeListener listener) {
        block7: {
            List<ListenerItem> list = this.listeners;
            synchronized (list) {
                if (this.isDisposed()) {
                    return;
                }
                int l = this.listeners.size();
                int i = 0;
                while (i < l) {
                    ListenerItem item = this.listeners.get(i);
                    if (item.listener == listener) {
                        this.listeners.remove(i);
                        break block7;
                    }
                    ++i;
                }
                return;
            }
        }
        PreferenceSetService service = EPreferences.getPreferenceSetService();
        if (service != null) {
            service.removeChangeListener(listener);
        }
    }

    private static class ListenerItem {
        private final PreferenceSetService.ChangeListener listener;
        private ImSet<String> qualifiers;

        public ListenerItem(PreferenceSetService.ChangeListener listener, ImSet<String> qualifiers) {
            this.listener = listener;
            this.qualifiers = qualifiers;
        }
    }
}

