/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.AbstractImLongList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImLongEmptyList
extends AbstractImLongList {
    public static final ImLongEmptyList INSTANCE = new ImLongEmptyList();

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(long element) {
        return false;
    }

    @Override
    public long getAt(int index) {
        throw new IndexOutOfBoundsException("index= " + index);
    }

    @Override
    public int indexOf(long element) {
        return -1;
    }

    @Override
    public int lastIndexOf(long element) {
        return -1;
    }

    @Override
    public LongStream stream() {
        return StreamSupport.longStream(Spliterators.emptyLongSpliterator(), false);
    }

    @Override
    public long[] toArray() {
        return ArrayUtils.EMPTY_LONG;
    }

    public int hashCode() {
        return 7;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongList) {
            LongList other = (LongList)obj;
            return other.isEmpty();
        }
        return false;
    }

    public String toString() {
        return "[]";
    }
}

