/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core.impl;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.impl.BasicSourceIssue;

@NonNullByDefault
public class BasicProblem
extends BasicSourceIssue
implements Problem {
    private final String categoryId;
    private final int severity;
    private final int code;
    private final String message;

    public BasicProblem(String categoryId, int severity, int code, String message, int line, int startOffset, int endOffset) {
        super(line, startOffset, endOffset);
        this.categoryId = categoryId;
        this.severity = severity;
        this.code = code;
        this.message = message;
    }

    public BasicProblem(String categoryId, int severity, int code, String message, int startOffset, int endOffset) {
        super(-1, startOffset, endOffset);
        this.categoryId = categoryId;
        this.severity = severity;
        this.code = code;
        this.message = message;
    }

    @Override
    public String getCategoryId() {
        return this.categoryId;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("Problem", this.getClass());
        sb.addProp("sourceOffset", '[', this.getSourceStartOffset(), this.getSourceEndOffset(), ')');
        sb.addProp("sourceLine", this.getSourceLine());
        sb.addProp("categoryId", this.getCategoryId());
        sb.addProp("severity", this.getSeverity());
        sb.addProp("code", this.getCode());
        sb.addProp("message", this.getMessage());
        return sb.toString();
    }
}

