/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.rmi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.RemoteException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.rmi.RMIAddress;

@NonNullByDefault
public class RMIUtils {
    private static final int ACCESS_TIMEOUT;

    static {
        int timeout = 15000;
        String s = System.getProperty("org.eclipse.statet.jcommons.rmi.AccessTimeout");
        if (s != null) {
            try {
                timeout = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ACCESS_TIMEOUT = timeout;
    }

    public static void checkRegistryAccess(RMIAddress rmiAddress) throws RemoteException {
        InetSocketAddress socketAddress = new InetSocketAddress(rmiAddress.getHostInetAddress(), rmiAddress.getPortNum());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Socket socket = new Socket();){
                try {
                    socket.setSoTimeout(ACCESS_TIMEOUT);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                socket.connect(socketAddress, ACCESS_TIMEOUT);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RemoteException("Cannot connect to RMI registry.", e);
        }
    }
}

