/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.viewer;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.io.win.DDE;
import org.eclipse.statet.ecommons.io.win.DDEClient;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariables;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceVariableUtil;
import org.eclipse.statet.ecommons.variables.core.StaticVariable;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.docmlet.base.ui.viewer.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.IWorkbenchPage;

@NonNullByDefault
public class DocViewerLaunchConfig {
    private IFile docFile;
    private ResourceVariableUtil docFileUtil;
    private @Nullable VariableText2 variableText;

    protected static CoreException createMissingConfigAttr(String attrName) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)"Invalid configuration: configuration attribute ''{0}'' is missing.", (Object)attrName)));
    }

    protected static CoreException createValidationFailed(FileValidator validator) {
        IStatus status = validator.getStatus();
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", status.getMessage()));
    }

    protected static CoreException createValidationFailed(String message) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", message));
    }

    public DocViewerLaunchConfig() {
    }

    public DocViewerLaunchConfig(ResourceVariableUtil sourceFileUtil, @Nullable Map<String, ? extends IStringVariable> extraVariables) {
        this.docFileUtil = (ResourceVariableUtil)ObjectUtils.nonNullAssert((Object)sourceFileUtil);
        this.setDocFile((IFile)ObjectUtils.nonNullAssert((Object)((IFile)sourceFileUtil.getResource())));
        if (extraVariables != null) {
            this.getVariableResolver().getExtraVariables().putAll(extraVariables);
        }
    }

    public VariableText2 getVariableResolver() {
        VariableText2 variableText = this.variableText;
        if (variableText == null) {
            HashMap variables = new HashMap();
            this.variableText = variableText = new VariableText2(variables);
        }
        return variableText;
    }

    public void initDocFile(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
        FileValidator validator = new FileValidator(true);
        validator.setResourceLabel("document");
        validator.setRequireWorkspace(true, true);
        validator.setOnDirectory(4);
        String path = configuration.getAttribute("org.eclipse.statet.docmlet.base/run/Target.path", null);
        if (path != null) {
            validator.setExplicit((Object)path);
        } else {
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ResourceVariableUtil util = new ResourceVariableUtil();
                    util.getResource();
                    DocViewerLaunchConfig.this.docFileUtil = util;
                }
            });
            if (this.docFileUtil.getResource() == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "No resource for 'document' to view selected in the active Workbench window."));
            }
            validator.setExplicit((Object)this.docFileUtil.getResource());
        }
        if (validator.getStatus().getSeverity() == 4) {
            throw DocViewerLaunchConfig.createValidationFailed(validator);
        }
        this.setDocFile((IFile)ObjectUtils.nonNullAssert((Object)((IFile)validator.getWorkspaceResource())));
    }

    protected void setDocFile(IFile file) {
        this.docFile = file;
        ResourceVariableUtil docFileUtil = (ResourceVariableUtil)ObjectUtils.nullable((Object)this.docFileUtil);
        if (docFileUtil == null) {
            docFileUtil = (ResourceVariableUtil)UIAccess.syncExecGet(() -> new ResourceVariableUtil((IResource)file));
            this.docFileUtil = (ResourceVariableUtil)ObjectUtils.nonNullAssert((Object)docFileUtil);
        }
        Map variables = this.getVariableResolver().getExtraVariables();
        VariableUtils.add((Map)variables, (Collection)ResourceVariables.getSingleResourceVariables(), (IDynamicVariableResolver)new ResourceVariableResolver((ResourceVariableResolver.Context)this.docFileUtil));
        VariableUtils.add((Map)variables, (IStringVariable)new StaticVariable((IStringVariable)DocProcessingConfig.SOURCE_FILE_PATH_VAR, file.getFullPath().toString()));
    }

    public IWorkbenchPage getWorkbenchPage() {
        return this.docFileUtil.getWorkbenchPage();
    }

    public IFile getSourceFile() {
        return this.docFile;
    }

    public ResourceVariableUtil getSourceFileVariableUtil() {
        return this.docFileUtil;
    }

    public ProcessBuilder initProgram(ILaunchConfiguration configuration) throws CoreException {
        FileValidator validator = new FileValidator(true);
        validator.setResourceLabel("program location");
        validator.setOnDirectory(4);
        validator.setVariableResolver(this.getVariableResolver());
        String path = configuration.getAttribute("org.eclipse.statet.docmlet.base/viewer/ProgramFile.path", null);
        if (path == null) {
            throw DocViewerLaunchConfig.createMissingConfigAttr("org.eclipse.statet.docmlet.base/viewer/ProgramFile.path");
        }
        validator.setExplicit((Object)path);
        if (validator.getStatus().getSeverity() == 4) {
            throw DocViewerLaunchConfig.createValidationFailed(validator);
        }
        IPath programPath = URIUtil.toPath((URI)validator.getFileStore().toURI());
        ProcessBuilder processBuilder = new ProcessBuilder(programPath.toOSString());
        ImList<String> arguments = this.getProgramArguments(configuration, this.getVariableResolver());
        if (!arguments.isEmpty()) {
            processBuilder.command().addAll((Collection<String>)arguments);
        }
        Map<String, String> environment = processBuilder.environment();
        environment.clear();
        environment.putAll(LaunchUtils.createEnvironment((ILaunchConfiguration)configuration, (Map[])new Map[0]));
        return processBuilder;
    }

    private ImList<String> getProgramArguments(ILaunchConfiguration configuration, VariableText2 variableResolver) throws CoreException {
        String arguments = configuration.getAttribute("org.eclipse.statet.docmlet.base/viewer/ProgramArguments.string", "");
        if (arguments.isEmpty()) {
            return ImCollections.emptyList();
        }
        try {
            arguments = variableResolver.performStringSubstitution(arguments, null);
            return ImCollections.newList((Object[])DebugPlugin.parseArguments((String)arguments));
        }
        catch (CoreException e) {
            throw DocViewerLaunchConfig.createValidationFailed(NLS.bind((String)Messages.ProgramArgs_error_Other_message, (Object)e.getMessage()));
        }
    }

    public @Nullable DDETask loadDDETask(ILaunchConfiguration configuration, String attrQualifier, @Nullable String taskLabel, SubMonitor m) throws CoreException {
        if (DDE.isSupported()) {
            String command;
            if (taskLabel == null) {
                taskLabel = "DDE";
            }
            if ((command = configuration.getAttribute(String.valueOf(attrQualifier) + '/' + "DDE.Command.message", null)) != null && !command.isEmpty()) {
                String application = configuration.getAttribute(String.valueOf(attrQualifier) + '/' + "DDE.Application.name", "");
                String topic = configuration.getAttribute(String.valueOf(attrQualifier) + '/' + "DDE.Topic.name", "");
                VariableText2 variableResolver = this.getVariableResolver();
                try {
                    command = variableResolver.performStringSubstitution(command, null);
                }
                catch (CoreException e) {
                    DocViewerLaunchConfig.createValidationFailed(NLS.bind((String)Messages.DDECommand_error_Other_message, (Object)taskLabel, (Object)e.getMessage()));
                }
                try {
                    application = variableResolver.performStringSubstitution(application, null);
                }
                catch (CoreException e) {
                    throw DocViewerLaunchConfig.createValidationFailed(NLS.bind((String)Messages.DDEApplication_error_Other_message, (Object)taskLabel, (Object)e.getMessage()));
                }
                try {
                    topic = variableResolver.performStringSubstitution(topic, null);
                }
                catch (CoreException e) {
                    throw DocViewerLaunchConfig.createValidationFailed(NLS.bind((String)Messages.DDETopic_error_Other_message, (Object)taskLabel, (Object)e.getMessage()));
                }
                return new DDETask(command, application, topic);
            }
        }
        return null;
    }

    public static class DDETask {
        private final String command;
        private final String application;
        private final String topic;

        public DDETask(String command, String application, String topic) {
            this.command = command;
            this.application = application;
            this.topic = topic;
        }

        public void exec() throws CoreException {
            DDEClient.execute((String)this.application, (String)this.topic, (String)this.command);
        }
    }
}

