/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.IssueMarkers;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.Task;
import org.eclipse.statet.ltk.issues.core.impl.BasicIssueRequestor;

@NonNullByDefault
public class ResourceMarkerIssueRequestor
extends BasicIssueRequestor {
    private final IFile resource;

    public static @Nullable ResourceMarkerIssueRequestor create(@Nullable Object resource, IssueTypeSet issueTypeSet) {
        if (resource instanceof IFile) {
            return new ResourceMarkerIssueRequestor((IFile)resource, issueTypeSet);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void clear(@Nullable Object resource, ImList<IssueTypeSet> issueTypeSets) throws CoreException {
        Object object = resource;
        if (object instanceof IResource) {
            IResource iResource = (IResource)object;
            IResource cfr_ignored_0 = (IResource)object;
            for (IssueTypeSet issueTypeSet : issueTypeSets) {
                ImIdentitySet<String> allTypes = issueTypeSet.getAllTypes(Ltk.PERSISTENCE_CONTEXT);
                if (allTypes == null) continue;
                for (String type : allTypes) {
                    void wsResource;
                    wsResource.deleteMarkers(type, true, 2);
                }
            }
        }
    }

    public static void clear(@Nullable Object resource, IssueTypeSet issueTypeSet) throws CoreException {
        ResourceMarkerIssueRequestor.clear(resource, (ImList<IssueTypeSet>)ImCollections.newList((Object)issueTypeSet));
    }

    public ResourceMarkerIssueRequestor(IFile file, IssueTypeSet issueTypeSet) {
        super(issueTypeSet, Ltk.PERSISTENCE_CONTEXT);
        this.resource = file;
    }

    @Override
    protected void reportIssues(@Nullable BasicIssueRequestor.TaskBatch taskBatch, ImList<BasicIssueRequestor.ProblemBatch> problemBatches) throws CoreException {
        if (taskBatch != null) {
            String type = (String)ObjectUtils.nonNullAssert((Object)((IssueTypeSet.TaskCategory)taskBatch.getCategory()).getType(Ltk.PERSISTENCE_CONTEXT));
            if (taskBatch.isEnabled()) {
                for (Task task : taskBatch.getAcceptedIssues()) {
                    Map<String, Object> attributes = this.createTaskAttributes(task);
                    this.resource.createMarker(type, attributes);
                }
            }
        }
        for (BasicIssueRequestor.ProblemBatch problemBatch : problemBatches) {
            IssueTypeSet.ProblemTypes types = (IssueTypeSet.ProblemTypes)ObjectUtils.nonNullAssert((Object)((IssueTypeSet.ProblemCategory)problemBatch.getCategory()).getTypes(Ltk.PERSISTENCE_CONTEXT));
            if (!problemBatch.isEnabled()) continue;
            for (Problem problem : problemBatch.getAcceptedIssues()) {
                Map<String, Object> attributes = this.createProblemAttributes(problem);
                this.resource.createMarker(types.getType(problem.getSeverity()), attributes);
            }
        }
    }

    protected Map<String, Object> createProblemAttributes(Problem problem) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("sourceId", this.getIssueTypeSet().getSourceId());
        attributes.put("categoryId", problem.getCategoryId());
        attributes.put("severity", IssueMarkers.toMarkerSeverity(problem.getSeverity()));
        attributes.put("code", problem.getCode());
        attributes.put("message", problem.getMessage());
        attributes.put("lineNumber", problem.getSourceLine() > 0 ? problem.getSourceLine() : 1);
        if (problem.getSourceStartOffset() >= 0) {
            attributes.put("charStart", problem.getSourceStartOffset());
            attributes.put("charEnd", problem.getSourceEndOffset());
        }
        attributes.put("userEditable", false);
        return attributes;
    }

    protected Map<String, Object> createTaskAttributes(Task task) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("sourceId", this.getIssueTypeSet().getSourceId());
        attributes.put("priority", IssueMarkers.toMarkerPriority(task.getPriority()));
        attributes.put("message", task.getMessage());
        attributes.put("lineNumber", task.getSourceLine() > 0 ? task.getSourceLine() : 1);
        if (task.getSourceStartOffset() >= 0) {
            attributes.put("charStart", task.getSourceStartOffset());
            attributes.put("charEnd", task.getSourceEndOffset());
        }
        attributes.put("userEditable", false);
        return attributes;
    }
}

