/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellPainter;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class GradientBackgroundPainter
extends CellPainterWrapper {
    private final boolean vertical;

    public GradientBackgroundPainter() {
        this(false);
    }

    public GradientBackgroundPainter(boolean vertical) {
        this.vertical = vertical;
    }

    public GradientBackgroundPainter(LayerCellPainter painter) {
        this(painter, false);
    }

    public GradientBackgroundPainter(LayerCellPainter painter, boolean vertical) {
        super(painter);
        this.vertical = vertical;
    }

    @Override
    public void paintCell(LayerCell cell, GC gc, LRectangle bounds, ConfigRegistry configRegistry) {
        Color foregroundColor = this.getForeGroundColour(cell, configRegistry);
        Color backgroundColor = this.getBackgroundColour(cell, configRegistry);
        if (backgroundColor != null && foregroundColor != null) {
            Color originalForeground = gc.getForeground();
            Color originalBackground = gc.getBackground();
            gc.setForeground(foregroundColor);
            gc.setBackground(backgroundColor);
            Rectangle rect = GraphicsUtils.safe(bounds);
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, this.vertical);
            gc.setForeground(originalForeground);
            gc.setBackground(originalBackground);
        }
        super.paintCell(cell, gc, bounds, configRegistry);
    }

    protected Color getForeGroundColour(LayerCell cell, ConfigRegistry configRegistry) {
        Color fgColor = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyling.GRADIENT_FOREGROUND_COLOR);
        return fgColor != null ? fgColor : CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyling.FOREGROUND_COLOR);
    }

    protected Color getBackgroundColour(LayerCell cell, ConfigRegistry configRegistry) {
        Color bgColor = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyling.GRADIENT_BACKGROUND_COLOR);
        return bgColor != null ? bgColor : CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyling.BACKGROUND_COLOR);
    }
}

