/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAsts;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAssistInvocationContext;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.PathCompletionComputor;

@NonNullByDefault
public class TexPathCompletionComputer
extends PathCompletionComputor {
    private @Nullable IContainer baseResource;
    private @Nullable IFileStore baseFileStore;

    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        this.baseResource = null;
        this.baseFileStore = null;
        SourceUnit su = editor.getSourceUnit();
        if (su instanceof WorkspaceSourceUnit) {
            IResource resource = ((WorkspaceSourceUnit)su).getResource();
            if (this.baseResource == null) {
                this.baseResource = resource.getParent();
            }
            if (this.baseResource != null) {
                try {
                    this.baseFileStore = EFS.getStore((URI)this.baseResource.getLocationURI());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        super.onSessionStarted(editor, assist);
    }

    public void onSessionEnded() {
        super.onSessionEnded();
    }

    protected char getDefaultFileSeparator() {
        return '/';
    }

    /*
     * WARNING - void declaration
     */
    protected @Nullable TextRegion getContentRegion(AssistInvocationContext context, int mode) throws BadLocationException {
        AssistInvocationContext assistInvocationContext = context;
        if (assistInvocationContext instanceof LtxAssistInvocationContext) {
            TexAstNode argNode;
            int argParameterIndex;
            void texContext;
            LtxAssistInvocationContext ltxAssistInvocationContext = (LtxAssistInvocationContext)assistInvocationContext;
            LtxAssistInvocationContext cfr_ignored_0 = (LtxAssistInvocationContext)assistInvocationContext;
            LtxAssistInvocationContext.CommandCall commandCall = texContext.getCommandCall(true);
            if (commandCall != null && (argParameterIndex = commandCall.getInvocationArgParameterIndex()) >= 0 && (argNode = commandCall.getArgNode(argParameterIndex)) != null) {
                TextRegion region;
                TexCommand command = commandCall.getCommand();
                TexCommand.Parameter param = (TexCommand.Parameter)command.getParameters().get(argParameterIndex);
                int offset = texContext.getInvocationOffset();
                if ((mode == 2 || (param.getContent() & 0xF0) == 64) && (region = TexAsts.getInnerRegion((TexAstNode)argNode)) != null && region.getStartOffset() >= offset && offset <= region.getEndOffset()) {
                    return region;
                }
            }
        }
        return null;
    }

    protected @Nullable IPath getRelativeBasePath() {
        IContainer baseResource = this.baseResource;
        if (baseResource != null) {
            return baseResource.getLocation();
        }
        return null;
    }

    protected @Nullable IFileStore getRelativeBaseStore() {
        IFileStore baseFileStore = this.baseFileStore;
        if (baseFileStore != null) {
            return baseFileStore;
        }
        return null;
    }
}

