/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench.workspace;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.model.WorkbenchContentProvider;

public final class ResourceContentProvider
extends WorkbenchContentProvider {
    private final int resourceType;

    public ResourceContentProvider(int resourceType) {
        this.resourceType = resourceType;
    }

    public Object[] getElements(Object element) {
        if (element instanceof IResource[]) {
            return (IResource[])element;
        }
        return this.getChildren(element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        try {
            if (!(element instanceof IContainer)) return false;
            IResource[] members = ((IContainer)element).members();
            int i = 0;
            while (true) {
                if (i >= members.length) {
                    return false;
                }
                if ((members[i].getType() & this.resourceType) != 0 && members[i].isAccessible()) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public Object[] getChildren(Object element) {
        try {
            if (element instanceof IContainer) {
                IResource[] members = ((IContainer)element).members();
                ArrayList<IResource> results = new ArrayList<IResource>(members.length);
                int i = 0;
                while (i < members.length) {
                    if ((members[i].getType() & this.resourceType) != 0 && members[i].isAccessible()) {
                        results.add(members[i]);
                    }
                    ++i;
                }
                return results.toArray();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new Object[0];
    }
}

