/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.List;
import java.util.Objects;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextElementName;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceElement;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.BasicWikitextSourceElement;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.ContainerSourceElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.element.EmbeddingForeignElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public class EmbeddingForeignSourceElement
extends BasicWikitextSourceElement
implements EmbeddingForeignElement<WikitextSourceElement, SourceStructElement<?, ?>> {
    private final ContainerSourceElement parent;
    private final String externType;
    private @Nullable SourceStructElement<?, ?> foreign;
    private final Embedded astNode;

    protected EmbeddingForeignSourceElement(String externType, ContainerSourceElement parent, Embedded astNode) {
        super(2048);
        this.externType = externType;
        this.parent = parent;
        this.astNode = astNode;
    }

    @Override
    public String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 32);
        sb.append(Integer.toHexString(this.getElementType() & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    @Override
    public ElementName getElementName() {
        SourceStructElement<?, ?> foreign = this.foreign;
        return foreign != null ? foreign.getElementName() : WikitextElementName.create(0, "");
    }

    public @Nullable TextRegion getNameSourceRange() {
        SourceStructElement<?, ?> foreign = this.foreign;
        return foreign != null ? foreign.getNameSourceRange() : null;
    }

    public SourceUnit getSourceUnit() {
        return this.parent.getSourceUnit();
    }

    public boolean exists() {
        return this.parent.exists();
    }

    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    @Override
    public WikitextSourceElement getModelParent() {
        return this.parent;
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super WikitextSourceElement> filter) {
        return false;
    }

    @Override
    public List<? extends WikitextSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super WikitextSourceElement> filter) {
        return NO_CHILDREN;
    }

    public @Nullable SourceStructElement<?, ?> getForeignElement() {
        return this.foreign;
    }

    public SourceStructElement<?, ?> getSourceParent() {
        return this.parent;
    }

    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        SourceStructElement<?, ?> foreign = this.foreign;
        return foreign != null && (filter == null || filter.include(foreign));
    }

    public List<? extends SourceStructElement<?, ?>> getSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        SourceStructElement<?, ?> foreign = this.foreign;
        return foreign != null && (filter == null || filter.include(foreign)) ? ImCollections.newList(foreign) : NO_CHILDREN;
    }

    public void setForeign(SourceStructElement<?, ?> foreign) {
        this.foreign = foreign;
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.astNode);
        }
        @Nullable T adapter = super.getAdapter(adapterType);
        if (adapter != null) {
            return adapter;
        }
        SourceStructElement<?, ?> foreign = this.foreign;
        if (foreign != null) {
            return (T)foreign.getAdapter(adapterType);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int h = 2048 * this.externType.hashCode() + this.occurrenceCount;
        SourceStructElement<?, ?> foreign = this.foreign;
        if (foreign != null) {
            h += foreign.hashCode() * 23917;
        }
        return h;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj) break block2;
                Object object = obj;
                if (!(object instanceof EmbeddingForeignSourceElement)) break block3;
                EmbeddingForeignSourceElement embeddingForeignSourceElement = (EmbeddingForeignSourceElement)object;
                EmbeddingForeignSourceElement cfr_ignored_0 = (EmbeddingForeignSourceElement)object;
                if (this.getSourceParent().equals(other.getSourceParent()) && Objects.equals(this.foreign, other.foreign)) break block2;
            }
            return false;
        }
        return true;
    }
}

