/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.internal.docmlet.tex.core.model.ProblemMessages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.impl.AbstractSourceIssueReporter;
import org.eclipse.statet.ltk.model.core.element.NameAccessSet;

@NonNullByDefault
public class LtxModelInspector
extends AbstractSourceIssueReporter {
    private final int levelRefUndefined = 1;

    public LtxModelInspector() {
        super("Ltx");
    }

    public void run(LtxSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor) {
        try {
            try {
                this.init(content, requestor);
                this.checkLabels(modelInfo);
                this.flush();
            }
            catch (OperationCanceledException operationCanceledException) {
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    private void checkLabels(LtxSourceUnitModelInfo model) {
        NameAccessSet<TexNameAccess> labelSet = model.getLabels();
        ImList labels = labelSet.getNames();
        block0: for (String label : labels) {
            if (label == null || label.length() <= 0) continue;
            ImList accessList = (ImList)ObjectUtils.nonNullAssert((Object)labelSet.getAllInUnit(label));
            for (TexNameAccess access : accessList) {
                if (access.isWriteAccess()) continue block0;
            }
            for (TexNameAccess access : accessList) {
                TexAstNode nameNode = (TexAstNode)access.getNameNode();
                this.addProblem(1, 2080, this.getMessageBuilder().bind(ProblemMessages.Labels_UndefinedRef_message, (Object)access.getDisplayName()), nameNode.getStartOffset(), nameNode.getEndOffset());
            }
        }
    }
}

