/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.statet.docmlet.wikitext.core.ast.Block;
import org.eclipse.statet.docmlet.wikitext.core.ast.Comment;
import org.eclipse.statet.docmlet.wikitext.core.ast.ContainerNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.Control;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.ast.Heading;
import org.eclipse.statet.docmlet.wikitext.core.ast.Image;
import org.eclipse.statet.docmlet.wikitext.core.ast.Label;
import org.eclipse.statet.docmlet.wikitext.core.ast.Link;
import org.eclipse.statet.docmlet.wikitext.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.wikitext.core.ast.Span;
import org.eclipse.statet.docmlet.wikitext.core.ast.Text;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupParser2;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextLocator;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.EmbeddingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.ImageByRefAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.LabelInfo;
import org.eclipse.statet.docmlet.wikitext.core.source.LinkByRefAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.LinkRefDefinitionAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceTextBlockAttributes;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.BasicStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.util.HtmlUtils;
import org.eclipse.statet.ltk.core.source.SourceContent;

public class WikidocParser
extends DocumentBuilder {
    public static final int COLLECT_COMMENTS = 1;
    private final StringFactory labelFactory;
    private WikitextMarkupLanguage markupLanguage;
    private SourceContent content;
    private WikitextLocator locator2;
    private WikitextAstNode currentNode;
    private boolean headingText;
    private int collectText;
    private Text currentText;
    private final StringBuilder textBuilder = new StringBuilder();
    private int depth;
    private final List<List<WikitextAstNode>> childrenStack = new ArrayList<List<WikitextAstNode>>();
    private final List<Comment> comments = new ArrayList<Comment>();
    private int commentsLevel;
    private @Nullable List<Embedded> embeddedList;

    public WikidocParser(@Nullable StringFactory labelFactory) {
        this.labelFactory = labelFactory != null ? labelFactory : BasicStringFactory.INSTANCE;
    }

    public void setMarkupLanguage(WikitextMarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public void setLocator(Locator locator) {
        super.setLocator(locator);
        this.locator2 = (WikitextLocator)locator;
    }

    public void setCommentLevel(int level) {
        level = (level & 1) == 0 ? 0 : (level &= 1);
        this.commentsLevel = level;
    }

    public void setCollectEmebeddedNodes(boolean enable) {
        this.embeddedList = enable ? new ArrayList(32) : null;
    }

    public List<Embedded> getEmbeddedNodes() {
        return this.embeddedList;
    }

    public void setCollectHeadingText(boolean enable) {
        this.headingText = enable;
    }

    protected void clearData() {
        if (this.commentsLevel != 0) {
            this.comments.clear();
        }
        CollectionUtils.clear(this.embeddedList);
    }

    private void initInput(SourceContent content) {
        this.content = content;
        this.clearData();
        this.depth = -1;
    }

    /*
     * Unable to fully structure code
     */
    public SourceComponent parse(SourceContent content) {
        try {
            this.initInput(content);
            markupParser = new MarkupParser2(this.markupLanguage, this);
            markupParser.disable(256);
            markupParser.enable(4096);
            markupParser.parse(content, true);
            node = (SourceComponent)this.currentNode;
            if (this.commentsLevel != 0) {
                node.comments = ImCollections.toList(this.comments);
            }
            var5_4 = node;
            ** while (this.depth >= 0)
        }
        catch (Throwable var4_7) {
            ** while (this.depth >= 0)
        }
lbl-1000:
        // 1 sources

        {
            list = this.childrenStack.get(this.depth);
            list.clear();
            --this.depth;
            continue;
        }
lbl16:
        // 1 sources

        return var5_4;
lbl-1000:
        // 1 sources

        {
            list = this.childrenStack.get(this.depth);
            list.clear();
            --this.depth;
            continue;
        }
lbl23:
        // 1 sources

        throw var4_7;
    }

    private void addChildNode(WikitextAstNode node) {
        List<WikitextAstNode> children = this.childrenStack.get(this.depth);
        children.add(node);
    }

    private void finishNode() {
        List<WikitextAstNode> children = this.childrenStack.get(this.depth);
        if (!children.isEmpty()) {
            ((ContainerNode)this.currentNode).children = children.toArray(new WikitextAstNode[children.size()]);
            children.clear();
        }
    }

    private void enterNode(WikitextAstNode node) {
        if (this.depth >= 0) {
            this.addChildNode(node);
        }
        ++this.depth;
        this.currentNode = node;
        if (this.depth == this.childrenStack.size()) {
            this.childrenStack.add(new ArrayList());
        }
    }

    private void exitNode(int offset) {
        this.finishNode();
        this.currentNode.setEndOffset(offset);
        this.currentNode = this.currentNode.parent;
        --this.depth;
    }

    private void finishText() {
        if (this.currentText == null) {
            return;
        }
        this.currentText.text = this.textBuilder.toString();
        this.currentText = null;
    }

    public void beginDocument() {
        this.enterNode(new SourceComponent(0, this.content.getLength()));
    }

    public void endDocument() {
        assert (this.currentNode instanceof SourceComponent);
        this.finishText();
        this.finishNode();
        --this.depth;
    }

    /*
     * WARNING - void declaration
     */
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        ContainerNode node;
        this.finishText();
        Attributes attributes2 = attributes;
        if (attributes2 instanceof EmbeddingAttributes) {
            void embeddingAttributes;
            EmbeddingAttributes embeddingAttributes2 = (EmbeddingAttributes)attributes2;
            EmbeddingAttributes cfr_ignored_0 = (EmbeddingAttributes)attributes2;
            Embedded embedded = new Embedded(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), embeddingAttributes.getForeignType(), embeddingAttributes.getEmbedDescr());
            node = embedded;
            if (this.embeddedList != null) {
                this.embeddedList.add(embedded);
            }
        } else {
            node = attributes instanceof SourceTextBlockAttributes ? new Block.TextBlock(this.currentNode, this.locator2.getBeginOffset(), type, attributes.getId(), ((SourceTextBlockAttributes)attributes).getTextRegions()) : new Block.Common(this.currentNode, this.locator2.getBeginOffset(), type, attributes.getId());
        }
        this.enterNode(node);
    }

    public void endBlock() {
        this.finishText();
        this.exitNode(this.locator2.getEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        ContainerNode node;
        this.finishText();
        Attributes attributes2 = attributes;
        if (attributes2 instanceof EmbeddingAttributes) {
            Embedded embedded;
            void embeddingAttributes;
            EmbeddingAttributes embeddingAttributes2 = (EmbeddingAttributes)attributes2;
            EmbeddingAttributes cfr_ignored_0 = (EmbeddingAttributes)attributes2;
            TextRegion contentRegion = embeddingAttributes.getContentRegion();
            if (contentRegion != null && contentRegion.getStartOffset() > this.locator2.getBeginOffset()) {
                Span span = new Span(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), type, attributes.getId());
                node = span;
                embedded = new Embedded(span, contentRegion.getStartOffset(), contentRegion.getEndOffset(), embeddingAttributes.getForeignType(), embeddingAttributes.getEmbedDescr());
                span.children = new WikitextAstNode[]{embedded};
            } else {
                embedded = new Embedded(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), embeddingAttributes.getForeignType(), embeddingAttributes.getEmbedDescr());
                node = embedded;
            }
            if (this.embeddedList != null) {
                this.embeddedList.add(embedded);
            }
        } else {
            node = type == DocumentBuilder.SpanType.LINK && attributes instanceof LinkAttributes ? this.createLink(attributes, null) : new Span(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), type, attributes.getId());
        }
        this.enterNode(node);
    }

    public void endSpan() {
        this.finishText();
        this.exitNode(this.locator2.getEndOffset());
    }

    public void beginHeading(int level, Attributes attributes) {
        this.finishText();
        this.enterNode(new Heading(this.currentNode, this.locator2.getBeginOffset(), level, attributes.getId()));
        if (this.headingText) {
            ++this.collectText;
        }
    }

    public void endHeading() {
        this.finishText();
        if (this.headingText) {
            --this.collectText;
        }
        this.exitNode(this.locator2.getEndOffset());
    }

    public void characters(String text) {
        if (this.currentText == null) {
            this.currentText = new Text(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset());
            this.addChildNode(this.currentText);
            this.textBuilder.setLength(0);
        } else {
            this.currentText.setEndOffsetMin(this.locator2.getEndOffset());
        }
        if (this.collectText > 0) {
            this.textBuilder.append(text);
        }
    }

    public void entityReference(String entity) {
        if (this.collectText > 0) {
            try {
                String resovled = HtmlUtils.resolveEntity((String)HtmlUtils.getEntityReference((String)entity));
                if (resovled != null) {
                    this.characters(resovled);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void image(Attributes attributes, String url) {
        this.finishText();
        this.addChildNode(this.createImage(attributes, url));
    }

    private Image createImage(Attributes attributes, String src) {
        LabelInfo referenceInfo;
        byte linkType;
        if (attributes instanceof ImageByRefAttributes) {
            linkType = 2;
            referenceInfo = ((ImageByRefAttributes)attributes).getReferenceLabel();
        } else {
            linkType = 0;
            referenceInfo = null;
        }
        if (linkType != 0 && referenceInfo != null) {
            Label referenceNode = this.createLabel(referenceInfo);
            return new Image.Ref(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), linkType, referenceNode);
        }
        return new Image.Common(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), 0, src);
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.finishText();
        this.addChildNode(this.createLink(attributes, null));
    }

    private Link createLink(Attributes attributes, String href) {
        if (href == null && attributes instanceof LinkAttributes) {
            href = ((LinkAttributes)attributes).getHref();
        }
        if (attributes instanceof LinkRefDefinitionAttributes) {
            byte linkType = 1;
            LabelInfo referenceInfo = ((LinkRefDefinitionAttributes)attributes).getReferenceLabel();
            if (referenceInfo != null) {
                Label referenceNode = this.createLabel(referenceInfo);
                return new Link.Ref(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), linkType, referenceNode, href, attributes.getTitle());
            }
        } else {
            if (attributes instanceof LinkByRefAttributes) {
                byte linkType = 2;
                LabelInfo referenceInfo = ((LinkByRefAttributes)attributes).getReferenceLabel();
                Label referenceNode = this.createLabel(referenceInfo);
                return new Link.Ref(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), linkType, referenceNode);
            }
            boolean linkType = false;
        }
        return new Link.Common(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), 0, href, attributes != null ? attributes.getTitle() : null);
    }

    private Label createLabel(LabelInfo labelInfo) {
        return new Label(null, labelInfo.getStartOffset(), labelInfo.getEndOffset(), labelInfo.getLabel());
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.finishText();
    }

    public void acronym(String text, String definition) {
        this.finishText();
    }

    public void lineBreak() {
        this.finishText();
        this.addChildNode(new Control(this.currentNode, this.locator2.getBeginOffset(), this.locator2.getEndOffset(), "\n"));
    }

    public void charactersUnescaped(String literal) {
        this.finishText();
    }
}

