/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.internal.r.core.pkgmanager.RVarRepo;
import org.eclipse.statet.internal.r.core.pkgmanager.Util;
import org.eclipse.statet.r.core.pkgmanager.RRepo;

public class RRepoListPref
extends Preference<List<RRepo>> {
    public RRepoListPref(String qualifier, String key) {
        super(qualifier, key);
    }

    public Class<List<RRepo>> getUsageType() {
        return List.class;
    }

    public List<RRepo> store2Usage(String storeValue) {
        String s = storeValue;
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        String[] repos = IS2_SEPARATOR_PATTERN.split(s);
        ArrayList<RRepo> list = new ArrayList<RRepo>(repos.length);
        int i = 0;
        while (i < repos.length) {
            String[] parts = IS1_SEPARATOR_PATTERN.split(repos[i]);
            if (parts.length >= 3) {
                list.add(RVarRepo.create(parts[0].intern(), parts[1], parts[2], parts.length >= 4 ? Util.getPkgType(parts[3]) : null));
            }
            ++i;
        }
        return list;
    }

    public String usage2Store(List<RRepo> usageValue) {
        if (usageValue.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(32 * usageValue.size());
        int i = 0;
        while (i < usageValue.size()) {
            RRepo repo = usageValue.get(i);
            sb.append(repo.getId());
            sb.append('\u001f');
            sb.append(repo.getName());
            sb.append('\u001f');
            sb.append(repo instanceof RVarRepo ? ((RVarRepo)repo).getRawURL() : repo.getURL());
            sb.append('\u001f');
            if (repo.getPkgType() != null) {
                sb.append(repo.getPkgType());
            }
            sb.append('\u001e');
            ++i;
        }
        return sb.substring(0, sb.length() - 1);
    }
}

